/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.handler;

import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.client.gui.PositionPreset;
import fuzs.pickupnotifier.client.gui.entry.DisplayEntry;
import fuzs.pickupnotifier.client.util.PickUpCollector;
import fuzs.pickupnotifier.config.ClientConfig;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.mutable.MutableInt;

public class DrawEntriesHandler {
    public static final PickUpCollector PICK_UPS = new PickUpCollector();
    public static final Int2ObjectArrayMap<MutableInt> HANDLED_ENTITIES = new Int2ObjectArrayMap();

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END && !Minecraft.m_91087_().m_91104_()) {
            if (!((ClientConfig)PickUpNotifier.CONFIG.client()).general().forceClient && !HANDLED_ENTITIES.isEmpty()) {
                HANDLED_ENTITIES.values().forEach(MutableInt::increment);
                HANDLED_ENTITIES.values().removeIf(time -> time.intValue() > 80);
            }
            if (((ClientConfig)PickUpNotifier.CONFIG.client()).behavior().displayTime != 0 && !PICK_UPS.isEmpty()) {
                PICK_UPS.tick();
            }
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlayText(RenderGameOverlayEvent.Text evt) {
        if (!PICK_UPS.isEmpty()) {
            float scale = (float)((ClientConfig)PickUpNotifier.CONFIG.client()).display().scale / 6.0f;
            int scaledWidth = (int)((float)evt.getWindow().m_85445_() / scale);
            int scaledHeight = (int)((float)evt.getWindow().m_85446_() / scale);
            PositionPreset position = ((ClientConfig)PickUpNotifier.CONFIG.client()).display().position;
            int posX = (int)((float)((ClientConfig)PickUpNotifier.CONFIG.client()).display().xOffset / scale);
            int posY = (int)((float)((ClientConfig)PickUpNotifier.CONFIG.client()).display().yOffset / scale);
            int offset = position.getY(18, scaledHeight, posY);
            int totalFade = ((ClientConfig)PickUpNotifier.CONFIG.client()).behavior().move ? (int)(PICK_UPS.getTotalFade(evt.getPartialTicks()) * 18.0) : 0;
            int entryY = offset + (position.isBottom() ? totalFade : -totalFade);
            int entryHeight = position.isBottom() ? 18 : -18;
            for (DisplayEntry entry : PICK_UPS) {
                boolean mayRender = false;
                if (position.isBottom()) {
                    if (entryY < offset + entryHeight) {
                        mayRender = true;
                    }
                } else if (entryY > offset + entryHeight) {
                    mayRender = true;
                }
                if (mayRender) {
                    int entryX = position.getX(entry.getEntryWidth(), scaledWidth, posX);
                    float alpha = ((ClientConfig)PickUpNotifier.CONFIG.client()).behavior().move ? Mth.m_14036_((float)((float)(entryY - offset) / (float)entryHeight), (float)0.0f, (float)1.0f) : entry.getRemainingTicksRelative(evt.getPartialTicks());
                    entry.render(evt.getMatrixStack(), entryX, entryY, alpha, scale);
                }
                entryY -= entryHeight;
            }
        }
    }
}

