/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.izofar.bygonenether.client.model.WarpedEndermanModel;
import com.izofar.bygonenether.client.renderer.layers.ModCarriedBlockLayer;
import com.izofar.bygonenether.client.renderer.layers.ModEnderEyesLayer;
import com.izofar.bygonenether.entity.WarpedEnderMan;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WarpedEnderManRenderer
extends MobRenderer<WarpedEnderMan, WarpedEndermanModel> {
    private static final Map<WarpedEnderMan.WarpedEnderManVariant, ResourceLocation> WARPED_ENDERMAN_LOCATION_MAP = ImmutableMap.of((Object)((Object)WarpedEnderMan.WarpedEnderManVariant.FRESH), (Object)new ResourceLocation("bygonenether", "textures/entity/warped_enderman/warped_enderman_fresh.png"), (Object)((Object)WarpedEnderMan.WarpedEnderManVariant.SHORT_VINE), (Object)new ResourceLocation("bygonenether", "textures/entity/warped_enderman/warped_enderman_short_vine.png"), (Object)((Object)WarpedEnderMan.WarpedEnderManVariant.LONG_VINE), (Object)new ResourceLocation("bygonenether", "textures/entity/warped_enderman/warped_enderman_long_vine.png"));
    private final Random random = new Random();

    public WarpedEnderManRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new WarpedEndermanModel(WarpedEndermanModel.createBodyLayer().m_171564_()), 0.5f);
        this.m_115326_((RenderLayer)new ModEnderEyesLayer(this));
        this.m_115326_(new ModCarriedBlockLayer(this));
    }

    public void render(WarpedEnderMan enderman, float p_114340_, float p_114341_, PoseStack p_114342_, MultiBufferSource p_114343_, int p_114344_) {
        BlockState blockstate = enderman.m_32530_();
        WarpedEndermanModel endermanmodel = (WarpedEndermanModel)this.m_7200_();
        endermanmodel.f_102576_ = blockstate != null;
        endermanmodel.f_102577_ = enderman.m_32531_();
        super.m_7392_((Mob)enderman, p_114340_, p_114341_, p_114342_, p_114343_, p_114344_);
    }

    public Vec3 getRenderOffset(WarpedEnderMan enderman, float offset) {
        return enderman.m_32531_() ? new Vec3(this.random.nextGaussian() * 0.02, 0.0, this.random.nextGaussian() * 0.02) : super.m_7860_((Entity)enderman, offset);
    }

    public ResourceLocation getTextureLocation(WarpedEnderMan enderman) {
        return WARPED_ENDERMAN_LOCATION_MAP.get((Object)enderman.getVariant());
    }
}

