/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.world.processors;

import com.izofar.bygonenether.init.ModProcessors;
import com.izofar.bygonenether.world.structure.util.ModStructureUtils;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import java.util.Locale;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.commons.lang3.math.NumberUtils;

public class DataBlockProcessor
extends StructureProcessor {
    public static final Codec<DataBlockProcessor> CODEC = Codec.unit(DataBlockProcessor::new);

    private DataBlockProcessor() {
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        BlockState blockState = structureBlockInfoWorld.f_74676_;
        if (blockState.m_60713_(Blocks.f_50677_)) {
            String metadata = structureBlockInfoWorld.f_74677_.m_128461_("metadata");
            BlockPos worldPos = structureBlockInfoWorld.f_74675_;
            try {
                if (metadata.contains(DATA_PROCESSOR_MODE.PILLARS.symbol)) {
                    String thirdArgument;
                    String[] splitString = metadata.split(DATA_PROCESSOR_MODE.PILLARS.symbol);
                    Direction direction = Direction.valueOf((String)splitString[0].toUpperCase(Locale.ROOT));
                    BlockStateParser blockArgumentParser = new BlockStateParser(new StringReader(splitString[1]), false);
                    blockArgumentParser.m_116806_(true);
                    BlockState replacementState = blockArgumentParser.m_116808_();
                    BlockState currentBlock = worldView.m_8055_(worldPos);
                    BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)worldPos);
                    int depth = Integer.MAX_VALUE;
                    if (splitString.length > 2 && NumberUtils.isParsable((String)(thirdArgument = splitString[2]))) {
                        depth = Integer.parseInt(thirdArgument) + 1;
                    }
                    int terrainY = Integer.MIN_VALUE;
                    if (direction == Direction.DOWN && depth == Integer.MAX_VALUE && (terrainY = ModStructureUtils.getFirstLandYFromPos(worldView, worldPos)) <= worldView.m_141937_()) {
                        return replacementState == null || replacementState.m_60713_(Blocks.f_50454_) ? null : new StructureTemplate.StructureBlockInfo(worldPos, replacementState, null);
                    }
                    while (!currentBlock.m_60815_() && currentPos.m_123342_() <= worldView.m_6042_().m_63964_() && currentPos.m_123342_() >= terrainY && currentPos.m_123314_((Vec3i)worldPos, (double)depth)) {
                        StructureTemplate.StructureBlockInfo newPillarState1 = new StructureTemplate.StructureBlockInfo(structureBlockInfoLocal.f_74675_, replacementState, null);
                        StructureTemplate.StructureBlockInfo newPillarState2 = new StructureTemplate.StructureBlockInfo(currentPos.m_7949_(), replacementState, null);
                        for (StructureProcessor processor : structurePlacementData.m_74411_()) {
                            if (newPillarState2 == null) break;
                            newPillarState2 = processor.m_7382_(worldView, pos, blockPos, newPillarState1, newPillarState2, structurePlacementData);
                        }
                        if (newPillarState2 != null) {
                            worldView.m_46865_((BlockPos)currentPos).m_6978_((BlockPos)currentPos, newPillarState2.f_74676_, false);
                        }
                        currentPos.m_122173_(direction);
                        currentBlock = worldView.m_8055_((BlockPos)currentPos);
                    }
                    return replacementState == null || replacementState.m_60713_(Blocks.f_50454_) ? null : new StructureTemplate.StructureBlockInfo(worldPos, replacementState, null);
                }
            }
            catch (CommandSyntaxException var11) {
                throw new RuntimeException(var11);
            }
        }
        return structureBlockInfoWorld;
    }

    protected StructureProcessorType<?> m_6953_() {
        return ModProcessors.DATA_BLOCK_PROCESSOR;
    }

    private static enum DATA_PROCESSOR_MODE {
        PILLARS("-");

        private final String symbol;

        private DATA_PROCESSOR_MODE(String symbol) {
            this.symbol = symbol;
        }
    }
}

