/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.world.structure;

import com.izofar.bygonenether.init.ModEntityTypes;
import com.izofar.bygonenether.world.structure.util.ModStructureUtils;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;

public class CitadelStructure
extends StructureFeature<JigsawConfiguration> {
    public static final List<MobSpawnSettings.SpawnerData> CITADEL_ENEMIES = List.of(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.WARPED_ENDERMAN.get(), 1, 1, 1), new MobSpawnSettings.SpawnerData(EntityType.f_20566_, 1, 1, 1));

    public CitadelStructure(Codec<JigsawConfiguration> codec) {
        super(codec, CitadelStructure::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    private static boolean checkLocation(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        BlockPos blockpos = context.f_197355_().m_151394_(0);
        NoiseColumn blockReader = context.f_197352_().m_141914_(blockpos.m_123341_(), blockpos.m_123343_(), context.f_197357_());
        return CitadelStructure.checkChunk(context) && !ModStructureUtils.isLavaLake(blockReader) && ModStructureUtils.verticalSpace(blockReader, 34, ModStructureUtils.getScaledNetherHeight(72), 12);
    }

    private static boolean checkChunk(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
        return context.f_197358_().test(context.f_197352_().m_203495_(QuartPos.m_175400_((int)context.f_197355_().m_151390_()), QuartPos.m_175400_((int)64), QuartPos.m_175400_((int)context.f_197355_().m_151393_())));
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        if (!CitadelStructure.checkLocation(context)) {
            return Optional.empty();
        }
        BlockPos blockpos = ModStructureUtils.getElevation(context, 48, ModStructureUtils.getScaledNetherHeight(70));
        return JigsawPlacement.m_210284_(context, PoolElementStructurePiece::new, (BlockPos)blockpos, (boolean)false, (boolean)false);
    }
}

