/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.world.structure.util;

import com.google.common.collect.ImmutableList;
import com.izofar.bygonenether.init.ModBlocks;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.feature.BasaltColumnsFeature;
import net.minecraft.world.level.levelgen.feature.DeltaFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraftforge.fml.ModList;

public abstract class ModStructureUtils {
    private static final Predicate<Block> isAir = block -> block == Blocks.f_50016_ || block == Blocks.f_50627_;

    public static boolean isLavaLake(NoiseColumn blockReader) {
        boolean isLake = true;
        if (blockReader.m_183556_(31).m_60734_() != Blocks.f_49991_) {
            isLake = false;
        } else {
            for (int i = 32; i < 70; ++i) {
                isLake = isLake && isAir.test(blockReader.m_183556_(i).m_60734_());
            }
        }
        return isLake;
    }

    public static boolean isBuried(NoiseColumn blockReader, int min, int max) {
        boolean found = false;
        for (int i = min; i < max; ++i) {
            if (!isAir.test(blockReader.m_183556_(i + 1).m_60734_()) || isAir.test(blockReader.m_183556_(i).m_60734_())) continue;
            found = true;
        }
        return !found;
    }

    public static boolean verticalSpace(NoiseColumn blockReader, int min, int max, int height) {
        int height_tracked = 0;
        for (int i = max; i >= min && height_tracked < height; --i) {
            if (isAir.test(blockReader.m_183556_(i).m_60734_())) {
                ++height_tracked;
                continue;
            }
            height_tracked = 0;
        }
        return height_tracked == height;
    }

    public static BlockPos getElevation(PieceGeneratorSupplier.Context<JigsawConfiguration> context, int min, int max) {
        BlockPos blockpos = context.f_197355_().m_151394_(0);
        NoiseColumn blockReader = context.f_197352_().m_141914_(blockpos.m_123341_(), blockpos.m_123343_(), context.f_197357_());
        boolean found = false;
        for (int i = min; i < max; ++i) {
            if (!isAir.test(blockReader.m_183556_(i + 1).m_60734_()) || isAir.test(blockReader.m_183556_(i).m_60734_())) continue;
            blockpos = new BlockPos(blockpos.m_123341_(), i, blockpos.m_123343_());
            found = true;
        }
        if (!found) {
            blockpos = new BlockPos(blockpos.m_123341_(), new Random(context.f_197354_()).nextInt(max - min) + min, blockpos.m_123343_());
        }
        return blockpos;
    }

    public static int getFirstLandYFromPos(LevelReader worldView, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.m_122190_((Vec3i)pos);
        ChunkAccess currentChunk = worldView.m_46865_((BlockPos)mutable);
        BlockState currentState = currentChunk.m_8055_((BlockPos)mutable);
        while (mutable.m_123342_() >= worldView.m_141937_() && ModStructureUtils.isReplaceableByStructures(currentState)) {
            mutable.m_122173_(Direction.DOWN);
            currentState = currentChunk.m_8055_((BlockPos)mutable);
        }
        return mutable.m_123342_();
    }

    private static boolean isReplaceableByStructures(BlockState blockState) {
        return blockState.m_60795_() || blockState.m_60767_().m_76332_() || blockState.m_60767_().m_76336_();
    }

    public static int getScaledNetherHeight(int vanillaHeight) {
        return (int)((float)vanillaHeight / 128.0f * (ModList.get().isLoaded("starmute") ? 256.0f : 128.0f));
    }

    public static void addBasaltRestrictions() {
        BasaltColumnsFeature.f_65150_ = ImmutableList.of((Object)Blocks.f_49991_, (Object)Blocks.f_50752_, (Object)Blocks.f_50450_, (Object)Blocks.f_50135_, (Object)Blocks.f_50197_, (Object)Blocks.f_50198_, (Object)Blocks.f_50199_, (Object)Blocks.f_50200_, (Object)Blocks.f_50087_, (Object)Blocks.f_50085_, (Object)Blocks.f_50412_, (Object)Blocks.f_50713_, (Object[])new Block[]{Blocks.f_50712_, Blocks.f_50452_, Blocks.f_50640_, Blocks.f_50601_, Blocks.f_50663_, (Block)ModBlocks.COBBLED_BLACKSTONE.get(), (Block)ModBlocks.WITHERED_BLACKSTONE.get(), (Block)ModBlocks.CHISELED_WITHERED_BLACKSTONE.get(), (Block)ModBlocks.CRACKED_WITHERED_BLACKSTONE.get(), (Block)ModBlocks.WITHERED_DEBRIS.get(), Blocks.f_50183_, Blocks.f_50353_});
        DeltaFeature.f_65546_ = ImmutableList.of((Object)Blocks.f_50752_, (Object)Blocks.f_50197_, (Object)Blocks.f_50198_, (Object)Blocks.f_50199_, (Object)Blocks.f_50200_, (Object)Blocks.f_50087_, (Object)Blocks.f_50085_, (Object)Blocks.f_50412_, (Object)Blocks.f_50713_, (Object)Blocks.f_50712_, (Object)Blocks.f_50452_, (Object)Blocks.f_50640_, (Object[])new Block[]{Blocks.f_50601_, Blocks.f_50663_, (Block)ModBlocks.COBBLED_BLACKSTONE.get(), (Block)ModBlocks.WITHERED_BLACKSTONE.get(), (Block)ModBlocks.CHISELED_WITHERED_BLACKSTONE.get(), (Block)ModBlocks.CRACKED_WITHERED_BLACKSTONE.get(), (Block)ModBlocks.WITHERED_DEBRIS.get(), Blocks.f_50183_, Blocks.f_50353_});
    }
}

