/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.structures.reanimated_ruins;

import com.legacy.dungeons_plus.registry.DPLoot;
import com.legacy.dungeons_plus.registry.DPStructures;
import com.legacy.dungeons_plus.structures.reanimated_ruins.ReanimatedRuinsType;
import com.legacy.structure_gel.api.block_entity.BlockEntityAccessHelper;
import com.legacy.structure_gel.api.config.StructureConfig;
import com.legacy.structure_gel.api.dynamic_spawner.DynamicSpawnerType;
import com.legacy.structure_gel.api.structure.GelConfigJigsawStructure;
import com.legacy.structure_gel.api.structure.base.IPieceBuilderModifier;
import com.legacy.structure_gel.api.structure.jigsaw.AbstractGelStructurePiece;
import com.legacy.structure_gel.api.structure.jigsaw.ExtendedJigsawConfiguration;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class ReanimatedRuinsStructure
extends GelConfigJigsawStructure<Configuration> {
    public ReanimatedRuinsStructure(Codec<Configuration> codec, StructureConfig config) {
        super(codec, config, 10, true, false, context -> true, Piece::new);
    }

    public int getSpacing() {
        return 36;
    }

    public int getOffset() {
        return this.getSpacing();
    }

    public void modifyPieceBuilder(StructurePiecesBuilder pieceBuilder, IPieceBuilderModifier.Context<Configuration> context) {
        List pieces = IPieceBuilderModifier.getPieces((StructurePiecesBuilder)pieceBuilder);
        pieces.removeIf(p -> {
            BoundingBox bounds = p.m_73547_();
            int minX = bounds.m_162395_();
            int maxY = bounds.m_162400_();
            int minZ = bounds.m_162401_();
            return maxY > context.chunkGen().m_142647_(minX, minZ, Heightmap.Types.WORLD_SURFACE_WG, context.level()) - 8;
        });
        for (StructurePiece p2 : pieces) {
            if (!(p2 instanceof Piece)) continue;
            Piece piece = (Piece)p2;
            piece.type = ((Configuration)context.config()).type;
        }
    }

    public static final class Piece
    extends AbstractGelStructurePiece {
        private ReanimatedRuinsType type = ReanimatedRuinsType.MOSSY;

        public Piece(StructureManager structureManager, StructurePoolElement poolElement, BlockPos pos, int groundLevelDelta, Rotation rotation, BoundingBox bounds) {
            super(structureManager, poolElement, pos, groundLevelDelta, rotation, bounds);
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag tag) {
            super(context, tag);
            this.type = ReanimatedRuinsType.byName(tag.m_128461_("type"));
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
            super.m_183620_(context, tag);
            tag.m_128359_("type", this.type.m_7912_());
        }

        public StructurePieceType m_210000_() {
            return DPStructures.REANIMATED_RUINS.getPieceType();
        }

        public BlockState modifyState(ServerLevelAccessor level, Random rand, BlockPos pos, BlockState original) {
            return this.type.modifierMap.modifiy(original, rand);
        }

        public void handleDataMarker(String key, BlockPos pos, ServerLevelAccessor level, Random rand, BoundingBox bounds) {
            if (key.startsWith("chest")) {
                this.setAir((LevelAccessor)level, pos);
                if (rand.nextFloat() < 0.6f || key.contains("always")) {
                    ResourceLocation loot;
                    loot = rand.nextFloat() < 0.5f ? (loot = this.type.loot) : DPLoot.ReanimatedRuins.CHEST_COMMON;
                    RandomizableContainerBlockEntity.m_59620_((BlockGetter)level, (Random)rand, (BlockPos)pos.m_7495_(), (ResourceLocation)loot);
                } else {
                    this.setAir((LevelAccessor)level, pos.m_7495_());
                }
            }
            if (key.startsWith("spawner")) {
                this.setAir((LevelAccessor)level, pos);
                if (rand.nextFloat() < 0.6f || key.contains("always")) {
                    BlockEntityAccessHelper.placeDynamicSpawner((ServerLevelAccessor)level, (BlockPos)pos, (DynamicSpawnerType)this.type.spawner);
                }
            }
            if (key.equals("decor")) {
                this.setAir((LevelAccessor)level, pos);
                this.type.decorate(level, pos, rand);
            }
        }
    }

    public static class Configuration
    extends ExtendedJigsawConfiguration {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(JigsawConfiguration::m_204802_), (App)Codec.intRange((int)0, (int)32).fieldOf("size").forGetter(JigsawConfiguration::m_67765_), (App)StringRepresentable.m_14350_(ReanimatedRuinsType::values, ReanimatedRuinsType::byName).fieldOf("type").forGetter(c -> c.type)).apply((Applicative)instance, Configuration::new));
        private final ReanimatedRuinsType type;

        public Configuration(Holder<StructureTemplatePool> startPool, int maxDepth, ReanimatedRuinsType type) {
            super(startPool, maxDepth);
            this.type = type;
        }
    }
}

