/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.structures.tower;

import com.legacy.dungeons_plus.DPUtil;
import com.legacy.dungeons_plus.DungeonsPlus;
import com.legacy.dungeons_plus.registry.DPStructures;
import com.legacy.structure_gel.api.structure.GelTemplateStructurePiece;
import com.legacy.structure_gel.api.structure.base.IModifyState;
import com.legacy.structure_gel.api.structure.processor.RandomBlockSwapProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.registries.ForgeRegistries;

public class TowerPieces {
    private static final ResourceLocation[] BASES = DungeonsPlus.locateAllPrefix("tower/base/", "camp", "flooded", "infested");
    private static final ResourceLocation[] FLOORS = DungeonsPlus.locateAllPrefix("tower/floor/", "zombie_0", "skeleton_0", "spider_0", "zombie_1", "skeleton_1", "spider_1", "zombie_2", "skeleton_2", "spider_2");
    private static final ResourceLocation[] TOP_FLOORS = DungeonsPlus.locateAllPrefix("tower/top_floor/", "vex_0", "vex_1", "vex_2");
    private static final ResourceLocation[] TOPS = DungeonsPlus.locateAllPrefix("tower/top/", "full", "decayed");

    public static void assemble(StructureManager structureManager, BlockPos pos, Rotation rotation, StructurePiecesBuilder pieces, Random rand) {
        boolean infested = (double)rand.nextFloat() < 0.3;
        pieces.m_142679_((StructurePiece)new Piece(structureManager, (ResourceLocation)Util.m_137545_((Object[])BASES, (Random)rand), pos, rotation, infested));
        int maxFloors = rand.nextInt(3) + 3;
        ArrayList<ResourceLocation> unusedFloors = new ArrayList<ResourceLocation>(Arrays.asList(FLOORS));
        for (int floor = 0; floor < maxFloors && unusedFloors.size() > 0; ++floor) {
            ResourceLocation floorName = (ResourceLocation)Util.m_143804_(unusedFloors, (Random)rand);
            pos = pos.m_6630_(6);
            pieces.m_142679_((StructurePiece)new Piece(structureManager, floorName, pos, rotation, infested));
            unusedFloors.remove(floorName);
        }
        pos = pos.m_6630_(6);
        pieces.m_142679_((StructurePiece)new Piece(structureManager, (ResourceLocation)Util.m_137545_((Object[])TOP_FLOORS, (Random)rand), pos, rotation, infested));
        pos = pos.m_6630_(6);
        pieces.m_142679_((StructurePiece)new Piece(structureManager, (ResourceLocation)Util.m_137545_((Object[])TOPS, (Random)rand), pos, rotation, infested));
    }

    public static class Piece
    extends GelTemplateStructurePiece {
        private static final String INFESTED_KEY = "infested";
        private static final ItemStack[] ARMOR_STAND_ITEMS = (ItemStack[])List.of(Items.f_42464_, Items.f_42476_, Items.f_42467_, Items.f_42478_, Items.f_42471_, Items.f_42479_).stream().map(ItemStack::new).toArray(ItemStack[]::new);
        private static final float MOSS_CHANCE = 0.2f;
        private static final float MOSS_BRICK_CHANCE = 0.15f;
        private static final float CRACK_BRICK_CHANCE = 0.15f;
        private static final float INFEST_CHANCE = 0.07f;
        private final boolean infested;

        public Piece(StructureManager structureManager, ResourceLocation location, BlockPos pos, Rotation rotation, boolean infested) {
            super(DPStructures.TOWER.getPieceType(), 0, structureManager, location, pos);
            this.f_73379_ = rotation;
            this.infested = infested;
            this.setupPlaceSettings(structureManager);
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag tag) {
            super(DPStructures.TOWER.getPieceType(), tag, context.f_192764_());
            this.infested = tag.m_128471_(INFESTED_KEY);
            this.setupPlaceSettings(context.f_192764_());
        }

        protected void m_183620_(StructurePieceSerializationContext level, CompoundTag tag) {
            super.m_183620_(level, tag);
            tag.m_128379_(INFESTED_KEY, this.infested);
        }

        protected StructurePlaceSettings getPlaceSettings(StructureManager structureManager) {
            StructurePlaceSettings settings = new StructurePlaceSettings();
            settings.m_163782_(false);
            Vec3i size = ((StructureTemplate)structureManager.m_163774_(this.m_142415_()).get()).m_163801_();
            settings.m_74385_(new BlockPos(size.m_123341_() / 2, 0, size.m_123343_() / 2));
            if (this.f_163658_.contains("top/decayed")) {
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(Blocks.f_50074_, 0.3f, Blocks.f_50016_));
            }
            return settings;
        }

        public BlockState modifyState(ServerLevelAccessor level, Random rand, BlockPos pos, BlockState originalState) {
            BlockState newState = this.modifyStateFirstPass(rand, originalState);
            if (this.infested) {
                newState = this.modifyStateInfest(rand, newState);
            }
            return newState;
        }

        private BlockState modifyStateFirstPass(Random rand, BlockState originalState) {
            Block originalBlock = originalState.m_60734_();
            if (originalBlock == Blocks.f_50652_ && rand.nextFloat() < 0.2f) {
                return Blocks.f_50079_.m_49966_();
            }
            if (originalBlock == Blocks.f_50409_ && rand.nextFloat() < 0.2f) {
                return IModifyState.mergeStates((BlockState)Blocks.f_50647_.m_49966_(), (BlockState)originalState);
            }
            if (originalBlock == Blocks.f_50157_ && rand.nextFloat() < 0.2f) {
                return IModifyState.mergeStates((BlockState)Blocks.f_50633_.m_49966_(), (BlockState)originalState);
            }
            if (originalBlock == Blocks.f_50222_) {
                float r = rand.nextFloat();
                if (r < 0.15f) {
                    return Blocks.f_50223_.m_49966_();
                }
                if (r < 0.3f) {
                    return Blocks.f_50224_.m_49966_();
                }
            } else {
                if (originalBlock == Blocks.f_50411_ && rand.nextFloat() < 0.15f) {
                    return IModifyState.mergeStates((BlockState)Blocks.f_50645_.m_49966_(), (BlockState)originalState);
                }
                if (originalBlock == Blocks.f_50194_ && rand.nextFloat() < 0.15f) {
                    return IModifyState.mergeStates((BlockState)Blocks.f_50631_.m_49966_(), (BlockState)originalState);
                }
                if (originalBlock == Blocks.f_152597_ && rand.nextFloat() < 0.2f) {
                    return Blocks.f_152550_.m_49966_();
                }
                if (originalBlock == Blocks.f_152589_ && rand.nextFloat() < 0.15f) {
                    return Blocks.f_152594_.m_49966_();
                }
            }
            return originalState;
        }

        private BlockState modifyStateInfest(Random rand, BlockState originalState) {
            if (originalState.m_204336_(BlockTags.f_13091_) && (double)rand.nextFloat() < 0.06) {
                return Blocks.f_50033_.m_49966_();
            }
            if (InfestedBlock.m_54195_((BlockState)originalState) && rand.nextFloat() < 0.07f) {
                return InfestedBlock.m_153430_((BlockState)originalState);
            }
            return originalState;
        }

        public void m_7756_(String key, BlockPos pos, ServerLevelAccessor level, Random rand, BoundingBox bounds) {
            if (key.equals("armor_stand")) {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                ArmorStand entity = (ArmorStand)EntityType.f_20529_.m_20615_((Level)level.m_6018_());
                entity.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5, this.f_73379_.m_55954_(Direction.SOUTH).m_122435_(), 0.0f);
                entity.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42477_));
                for (ItemStack item : ARMOR_STAND_ITEMS) {
                    if (!((double)rand.nextFloat() < 0.25)) continue;
                    entity.m_8061_(Mob.m_147233_((ItemStack)item), item);
                }
                level.m_7967_((Entity)entity);
            }
            if (key.startsWith("waystone")) {
                DPUtil.placeWaystone(level, pos, rand, (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(key.split("-")[1])));
            }
        }
    }
}

