/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.TileDataShim;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.extensions.IForgeBlockEntity;

public class ChamTileEntity
extends BlockEntity
implements IForgeBlockEntity {
    private CompoundTag failureSnapshot;
    private List<TileDataShim> fixedShims;
    private List<TileDataShim> portableShims;

    public ChamTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public boolean hasDataPacket() {
        return true;
    }

    public boolean dataPacketRequiresRenderUpdate() {
        return false;
    }

    public void injectData(TileDataShim shim) {
        if (this.fixedShims == null) {
            this.fixedShims = new ArrayList<TileDataShim>();
        }
        this.fixedShims.add(shim);
    }

    public void injectPortableData(TileDataShim shim) {
        if (this.portableShims == null) {
            this.portableShims = new ArrayList<TileDataShim>();
        }
        this.portableShims.add(shim);
    }

    public final void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.readFixed(tag);
        this.readPortable(tag);
    }

    public final void read(CompoundTag tag) {
        this.m_142466_(tag);
    }

    protected void m_183515_(CompoundTag tag) {
        tag = this.writeFixed(tag);
        this.writePortable(tag);
    }

    public void readPortable(CompoundTag tag) {
        if (this.portableShims != null) {
            for (TileDataShim shim : this.portableShims) {
                shim.read(tag);
            }
        }
    }

    public CompoundTag writePortable(CompoundTag tag) {
        if (this.portableShims != null) {
            for (TileDataShim shim : this.portableShims) {
                tag = shim.write(tag);
            }
        }
        return tag;
    }

    protected void readFixed(CompoundTag tag) {
        if (this.fixedShims != null) {
            for (TileDataShim shim : this.fixedShims) {
                shim.read(tag);
            }
        }
    }

    protected CompoundTag writeFixed(CompoundTag tag) {
        if (this.fixedShims != null) {
            for (TileDataShim shim : this.fixedShims) {
                tag = shim.write(tag);
            }
        }
        return tag;
    }

    private void trapLoadFailure(Throwable t, CompoundTag tag) {
        this.failureSnapshot = tag.m_6426_();
        StorageDrawers.log.error("Tile Load Failure.", t);
    }

    private void restoreLoadFailure(CompoundTag tag) {
        for (String key : this.failureSnapshot.m_128431_()) {
            if (tag.m_128441_(key)) continue;
            tag.m_128365_(key, this.failureSnapshot.m_128423_(key).m_6426_());
        }
    }

    protected boolean loadDidFail() {
        return this.failureSnapshot != null;
    }

    public final CompoundTag m_5995_() {
        CompoundTag tag = this.m_187482_();
        return tag;
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return this.hasDataPacket() ? ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this) : null;
    }

    public final void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt != null && pkt.m_131708_() != null) {
            this.read(pkt.m_131708_());
        }
        if (this.dataPacketRequiresRenderUpdate() && this.m_58904_().f_46443_) {
            BlockState state = this.m_58904_().m_8055_(this.m_58899_());
            this.m_58904_().m_7260_(this.m_58899_(), state, state, 3);
        }
    }

    public void markBlockForUpdate() {
        if (this.m_58904_() != null && !this.m_58904_().f_46443_) {
            BlockState state = this.m_58904_().m_8055_(this.f_58858_);
            this.m_58904_().m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public void markBlockForUpdateClient() {
        if (this.m_58904_() != null && this.m_58904_().f_46443_) {
            BlockState state = this.m_58904_().m_8055_(this.f_58858_);
            this.m_58904_().m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public void markBlockForRenderUpdate() {
        if (this.m_58904_() == null) {
            return;
        }
        BlockState state = this.m_58904_().m_8055_(this.f_58858_);
        this.m_58904_().m_7260_(this.f_58858_, state, state, 2);
    }
}

