/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.phosphor.mixin.chunk.light;

import net.caffeinemc.phosphor.common.chunk.light.BlockLightStorageAccess;
import net.caffeinemc.phosphor.common.util.LightUtil;
import net.caffeinemc.phosphor.common.util.math.DirectionHelper;
import net.caffeinemc.phosphor.mixin.chunk.light.MixinChunkLightProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.BlockLightEngine;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BlockLightEngine.class})
public abstract class MixinChunkBlockLightProvider
extends MixinChunkLightProvider {
    @Shadow
    @Final
    private static Direction[] f_75488_;

    @Shadow
    protected abstract int m_75508_(long var1);

    @Override
    @Overwrite
    public int m_6359_(long fromId, long toId, int currentLevel) {
        return this.getPropagatedLevel(fromId, null, toId, currentLevel);
    }

    @Override
    public int getPropagatedLevel(long fromId, BlockState fromState, long toId, int currentLevel) {
        int fromZ;
        int fromY;
        if (toId == Long.MAX_VALUE) {
            return 15;
        }
        if (fromId == Long.MAX_VALUE && ((BlockLightStorageAccess)this.f_75632_).isLightEnabled(SectionPos.m_123235_((long)toId))) {
            return currentLevel + 15 - this.m_75508_(toId);
        }
        if (currentLevel >= 15) {
            return currentLevel;
        }
        int toX = BlockPos.m_121983_((long)toId);
        int toY = BlockPos.m_122008_((long)toId);
        int toZ = BlockPos.m_122015_((long)toId);
        int fromX = BlockPos.m_121983_((long)fromId);
        Direction dir = DirectionHelper.getVecDirection(toX - fromX, toY - (fromY = BlockPos.m_122008_((long)fromId)), toZ - (fromZ = BlockPos.m_122015_((long)fromId)));
        if (dir != null) {
            VoxelShape bShape;
            VoxelShape aShape;
            BlockState toState = this.getBlockStateForLighting(toX, toY, toZ);
            if (toState == null) {
                return 15;
            }
            int newLevel = this.getSubtractedLight(toState, toX, toY, toZ);
            if (newLevel >= 15) {
                return 15;
            }
            if (fromState == null) {
                fromState = this.getBlockStateForLighting(fromX, fromY, fromZ);
            }
            if (!LightUtil.unionCoversFullCube(aShape = this.getOpaqueShape(fromState, fromX, fromY, fromZ, dir), bShape = this.getOpaqueShape(toState, toX, toY, toZ, dir.m_122424_()))) {
                return currentLevel + Math.max(1, newLevel);
            }
        }
        return 15;
    }

    @Overwrite
    public void m_7900_(long id, int targetLevel, boolean mergeAsMin) {
        int x = BlockPos.m_121983_((long)id);
        int y = BlockPos.m_122008_((long)id);
        int z = BlockPos.m_122015_((long)id);
        long chunk = SectionPos.m_123209_((int)SectionPos.m_123171_((int)x), (int)SectionPos.m_123171_((int)y), (int)SectionPos.m_123171_((int)z));
        BlockState state = this.getBlockStateForLighting(x, y, z);
        for (Direction dir : f_75488_) {
            int adjX = x + dir.m_122429_();
            int adjY = y + dir.m_122430_();
            int adjZ = z + dir.m_122431_();
            long adjChunk = SectionPos.m_123209_((int)SectionPos.m_123171_((int)adjX), (int)SectionPos.m_123171_((int)adjY), (int)SectionPos.m_123171_((int)adjZ));
            if (chunk != adjChunk && !this.hasSection(adjChunk)) continue;
            this.propagateLevel(id, state, BlockPos.m_121882_((int)adjX, (int)adjY, (int)adjZ), targetLevel, mergeAsMin);
        }
    }
}

