/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.phosphor.mixin.chunk.light;

import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import net.caffeinemc.phosphor.common.chunk.light.LevelPropagatorAccess;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.DynamicGraphMinFixedPoint;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={DynamicGraphMinFixedPoint.class})
public abstract class MixinLevelPropagator
implements LevelPropagatorAccess {
    @Shadow
    @Final
    private Long2ByteMap f_75539_;
    @Shadow
    @Final
    private int f_75537_;
    @Shadow
    private volatile boolean f_75541_;
    @Shadow
    private int f_75540_;

    @Shadow
    protected abstract int m_6172_(long var1);

    @Shadow
    protected abstract int m_6359_(long var1, long var3, int var5);

    @Shadow
    protected abstract void m_75569_(long var1, long var3, int var5, int var6, int var7, boolean var8);

    @Override
    @Invoker(value="propagateLevel")
    public abstract void invokePropagateLevel(long var1, long var3, int var5, boolean var6);

    @Shadow
    protected abstract void m_75593_(long var1, long var3, int var5, boolean var6);

    @Shadow
    protected abstract void m_75600_(long var1);

    @Override
    public void propagateLevel(long sourceId, long targetId, boolean decrease) {
        this.m_75593_(sourceId, targetId, this.m_6172_(sourceId), decrease);
    }

    @Override
    public void checkForUpdates() {
        this.f_75541_ = this.f_75540_ < this.f_75537_;
    }

    @Unique
    protected void propagateLevel(long sourceId, BlockState sourceState, long targetId, int level, boolean decrease) {
        int resultLevel;
        boolean flag;
        int pendingLevel = this.f_75539_.get(targetId) & 0xFF;
        int propagatedLevel = this.getPropagatedLevel(sourceId, sourceState, targetId, level);
        int clampedLevel = Mth.m_14045_((int)propagatedLevel, (int)0, (int)(this.f_75537_ - 1));
        if (decrease) {
            this.m_75569_(sourceId, targetId, clampedLevel, this.m_6172_(targetId), pendingLevel, true);
            return;
        }
        if (pendingLevel == 255) {
            flag = true;
            resultLevel = Mth.m_14045_((int)this.m_6172_(targetId), (int)0, (int)(this.f_75537_ - 1));
        } else {
            resultLevel = pendingLevel;
            flag = false;
        }
        if (clampedLevel == resultLevel) {
            this.m_75569_(sourceId, targetId, this.f_75537_ - 1, flag ? resultLevel : this.m_6172_(targetId), pendingLevel, false);
        }
    }

    @Unique
    protected int getPropagatedLevel(long sourceId, BlockState sourceState, long targetId, int level) {
        return this.m_6359_(sourceId, targetId, level);
    }

    @Redirect(method={"removePendingUpdate(JIIZ)V", "applyPendingUpdates"}, at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/longs/Long2ByteMap;remove(J)B", remap=false))
    private byte redirectRemovePendingUpdate(Long2ByteMap map, long key) {
        byte ret = map.remove(key);
        if (ret != map.defaultReturnValue()) {
            this.onPendingUpdateRemoved(key);
        }
        return ret;
    }

    @Redirect(method={"addPendingUpdate"}, at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/longs/Long2ByteMap;put(JB)B", remap=false))
    private byte redirectAddPendingUpdate(Long2ByteMap map, long key, byte value) {
        byte ret = map.put(key, value);
        if (ret == map.defaultReturnValue()) {
            this.onPendingUpdateAdded(key);
        }
        return ret;
    }

    @Unique
    protected void onPendingUpdateAdded(long key) {
    }

    @Unique
    protected void onPendingUpdateRemoved(long key) {
    }
}

