/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import top.theillusivec4.diet.api.DietCapability;
import top.theillusivec4.diet.api.IDietGroup;
import top.theillusivec4.diet.client.DietKeys;
import top.theillusivec4.diet.client.DietTooltip;
import top.theillusivec4.diet.common.config.DietClientConfig;
import top.theillusivec4.diet.common.effect.DietEffectsInfo;
import top.theillusivec4.diet.common.group.DietGroups;

public class DietScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("minecraft", "textures/gui/demo_background.png");
    private static final ResourceLocation ICONS = new ResourceLocation("diet", "textures/gui/icons.png");
    public static DietEffectsInfo tooltip = new DietEffectsInfo();
    private final int xSize;
    private final int ySize = DietGroups.get().size() * 20 + 60;
    private final boolean fromInventory;

    public DietScreen(boolean fromInventory) {
        super((Component)new TranslatableComponent("gui.diet.title"));
        this.xSize = 248;
        this.fromInventory = fromInventory;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 50, (this.f_96544_ + this.ySize) / 2 - 30, 100, 20, (Component)new TranslatableComponent("gui.diet.close"), p_213002_1_ -> {
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                if (this.fromInventory) {
                    this.f_96541_.m_91152_((Screen)new InventoryScreen((Player)this.f_96541_.f_91074_));
                } else {
                    this.m_7379_();
                }
            }
        }));
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        this.renderForeground(matrixStack, mouseX, mouseY);
        this.renderTitle(matrixStack, mouseX, mouseY);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void renderTitle(PoseStack matrixStack, int mouseX, int mouseY) {
        int titleWidth = this.f_96547_.m_92895_(this.f_96539_.getString());
        this.f_96547_.m_92889_(matrixStack, this.f_96539_, (float)this.f_96543_ / 2.0f - (float)titleWidth / 2.0f, (float)this.f_96544_ / 2.0f - (float)this.ySize / 2.0f + 10.0f, DietClientConfig.textColor);
        List<DietEffectsInfo.AttributeModifier> modifiers = tooltip.getModifiers();
        List<DietEffectsInfo.StatusEffect> effects = tooltip.getEffects();
        if (!(this.f_96541_ == null || modifiers.isEmpty() && effects.isEmpty())) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)ICONS);
            int lowerX = this.f_96543_ / 2 + titleWidth / 2 + 5;
            int lowerY = this.f_96544_ / 2 - this.ySize / 2 + 7;
            int upperX = lowerX + 16;
            int upperY = lowerY + 16;
            GuiComponent.m_93160_((PoseStack)matrixStack, (int)lowerX, (int)lowerY, (int)16, (int)16, (float)0.0f, (float)37.0f, (int)16, (int)16, (int)256, (int)256);
            if (mouseX >= lowerX && mouseX <= upperX && mouseY >= lowerY && mouseY <= upperY) {
                List<Component> tooltips = DietTooltip.getEffects();
                this.m_96597_(matrixStack, tooltips, mouseX, mouseY);
            }
        }
    }

    public void renderForeground(PoseStack matrixStack, int mouseX, int mouseY) {
        LocalPlayer player;
        if (this.f_96541_ != null && (player = this.f_96541_.f_91074_) != null) {
            DietCapability.get((Player)player).ifPresent(diet -> {
                int y = this.f_96544_ / 2 - this.ySize / 2 + 25;
                int x = this.f_96543_ / 2 - this.xSize / 2 + 10;
                TranslatableComponent tooltip = null;
                for (IDietGroup group : DietGroups.get()) {
                    this.f_96542_.m_115123_(new ItemStack((ItemLike)group.getIcon()), x, y - 5);
                    TranslatableComponent text = new TranslatableComponent("groups.diet." + group.getName() + ".name");
                    this.f_96547_.m_92889_(matrixStack, (Component)text, (float)(x + 20), (float)y, DietClientConfig.textColor);
                    RenderSystem.m_157427_(GameRenderer::m_172814_);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)ICONS);
                    Color color = diet.isActive() ? group.getColor() : Color.gray;
                    int red = color.getRed();
                    int green = color.getGreen();
                    int blue = color.getBlue();
                    int alpha = color.getAlpha();
                    int percent = (int)Math.floor(diet.getValue(group.getName()) * 100.0f);
                    String percentText = percent + "%";
                    DietScreen.coloredBlit(matrixStack, x + 90, y + 2, 102, 5, 20.0f, 0.0f, 102, 5, 256, 256, red, green, blue, alpha);
                    if (percent > 0) {
                        int texWidth = percent + 1;
                        DietScreen.coloredBlit(matrixStack, x + 90, y + 2, texWidth, 5, 20.0f, 5.0f, texWidth, 5, 256, 256, red, green, blue, alpha);
                    }
                    int xPos = x + 200;
                    int yPos = y + 1;
                    this.f_96547_.m_92883_(matrixStack, percentText, (float)(xPos + 1), (float)yPos, 0);
                    this.f_96547_.m_92883_(matrixStack, percentText, (float)(xPos - 1), (float)yPos, 0);
                    this.f_96547_.m_92883_(matrixStack, percentText, (float)xPos, (float)(yPos + 1), 0);
                    this.f_96547_.m_92883_(matrixStack, percentText, (float)xPos, (float)(yPos - 1), 0);
                    this.f_96547_.m_92883_(matrixStack, percentText, (float)xPos, (float)yPos, color.getRGB());
                    int lowerY = y - 5;
                    int upperX = x + 16;
                    int upperY = lowerY + 16;
                    if (mouseX >= x && mouseX <= upperX && mouseY >= lowerY && mouseY <= upperY) {
                        String key = "groups.diet." + group.getName() + ".tooltip";
                        if (Language.m_128107_().m_6722_(key)) {
                            tooltip = new TranslatableComponent(key);
                        }
                    }
                    y += 20;
                }
                if (tooltip != null) {
                    ArrayList tooltips = Lists.newArrayList((Object[])new Component[]{tooltip});
                    this.m_96597_(matrixStack, tooltips, mouseX, mouseY);
                }
            });
        }
    }

    public void m_7333_(@Nonnull PoseStack matrixStack) {
        super.m_7333_(matrixStack);
        if (this.f_96541_ != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
            int i = (this.f_96543_ - this.xSize) / 2;
            int j = (this.f_96544_ - this.ySize) / 2;
            GuiComponent.m_93160_((PoseStack)matrixStack, (int)i, (int)j, (int)this.xSize, (int)4, (float)0.0f, (float)0.0f, (int)248, (int)4, (int)256, (int)256);
            GuiComponent.m_93160_((PoseStack)matrixStack, (int)i, (int)(j + 4), (int)this.xSize, (int)(this.ySize - 8), (float)0.0f, (float)4.0f, (int)248, (int)24, (int)256, (int)256);
            GuiComponent.m_93160_((PoseStack)matrixStack, (int)i, (int)(j + this.ySize - 4), (int)this.xSize, (int)4, (float)0.0f, (float)162.0f, (int)248, (int)4, (int)256, (int)256);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            if (this.f_96541_.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
                this.f_96541_.m_91152_((Screen)new InventoryScreen((Player)this.f_96541_.f_91074_));
                return true;
            }
            if (DietKeys.OPEN_GUI.m_90832_(keyCode, scanCode)) {
                if (this.fromInventory) {
                    this.f_96541_.m_91152_((Screen)new InventoryScreen((Player)this.f_96541_.f_91074_));
                } else {
                    this.m_7379_();
                }
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }

    private static void coloredBlit(PoseStack matrixStack, int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight, int red, int green, int blue, int alpha) {
        int x2 = x + width;
        int y2 = y + height;
        float minU = (uOffset + 0.0f) / (float)textureWidth;
        float maxU = (uOffset + (float)uWidth) / (float)textureWidth;
        float minV = (vOffset + 0.0f) / (float)textureHeight;
        float maxV = (vOffset + (float)vHeight) / (float)textureHeight;
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferbuilder.m_85982_(matrix, (float)x, (float)y2, 0.0f).m_6122_(red, green, blue, alpha).m_7421_(minU, maxV).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)x2, (float)y2, 0.0f).m_6122_(red, green, blue, alpha).m_7421_(maxU, maxV).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)x2, (float)y, 0.0f).m_6122_(red, green, blue, alpha).m_7421_(maxU, minV).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)x, (float)y, 0.0f).m_6122_(red, green, blue, alpha).m_7421_(minU, minV).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
    }
}

