/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.common.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.TranslatableComponent;
import top.theillusivec4.diet.api.IDietGroup;
import top.theillusivec4.diet.common.group.DietGroups;

public class DietGroupArgument
implements ArgumentType<IDietGroup> {
    private static final Collection<String> EXAMPLES = Arrays.asList("fruits", "vegetables");
    public static final DynamicCommandExceptionType GROUP_UNKNOWN = new DynamicCommandExceptionType(group -> new TranslatableComponent("commands.diet.group.unknown", new Object[]{group}));

    public static DietGroupArgument group() {
        return new DietGroupArgument();
    }

    public static IDietGroup getGroup(CommandContext<CommandSourceStack> context, String name) {
        return (IDietGroup)context.getArgument(name, IDietGroup.class);
    }

    public IDietGroup parse(StringReader input) throws CommandSyntaxException {
        String name = input.readString();
        for (IDietGroup group : DietGroups.get()) {
            if (!name.equals(group.getName())) continue;
            return group;
        }
        throw GROUP_UNKNOWN.create((Object)name);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> ctx, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82981_(DietGroups.get().stream().map(IDietGroup::getName), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

