/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.common.effect;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import top.theillusivec4.diet.DietMod;

public class DietEffect {
    public final List<DietAttribute> attributes;
    public final List<DietStatusEffect> statusEffects;
    public final List<Condition> conditions;
    public final UUID uuid;

    public DietEffect(UUID uuid, List<DietAttribute> attributes, List<DietStatusEffect> statusEffects, List<Condition> conditions) {
        this.attributes = attributes;
        this.statusEffects = statusEffects;
        this.conditions = conditions;
        this.uuid = uuid;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum MatchMethod {
        EVERY{

            @Override
            int getMatches(Set<String> groups, Map<String, Float> values, float above, float below) {
                int count = 0;
                for (String group : groups) {
                    Float value = values.get(group);
                    if (value == null || !MatchMethod.inRange(value.floatValue(), above, below)) continue;
                    ++count;
                }
                return count;
            }
        }
        ,
        ANY{

            @Override
            int getMatches(Set<String> groups, Map<String, Float> values, float above, float below) {
                for (String group : groups) {
                    Float value = values.get(group);
                    if (value == null || !MatchMethod.inRange(value.floatValue(), above, below)) continue;
                    return 1;
                }
                return 0;
            }
        }
        ,
        AVERAGE{

            @Override
            int getMatches(Set<String> groups, Map<String, Float> values, float above, float below) {
                float sum = 0.0f;
                for (String group : groups) {
                    Float value = values.get(group);
                    if (value == null) continue;
                    sum += value.floatValue();
                }
                return MatchMethod.inRange(sum / (float)groups.size(), above, below) ? 1 : 0;
            }
        }
        ,
        ALL{

            @Override
            int getMatches(Set<String> groups, Map<String, Float> values, float above, float below) {
                for (String group : groups) {
                    Float value = values.get(group);
                    if (value != null && MatchMethod.inRange(value.floatValue(), above, below)) continue;
                    return 0;
                }
                return 1;
            }
        }
        ,
        NONE{

            @Override
            int getMatches(Set<String> groups, Map<String, Float> values, float above, float below) {
                for (String group : groups) {
                    Float value = values.get(group);
                    if (value == null || !MatchMethod.inRange(value.floatValue(), above, below)) continue;
                    return 0;
                }
                return 1;
            }
        };


        abstract int getMatches(Set<String> var1, Map<String, Float> var2, float var3, float var4);

        public static MatchMethod findOrDefault(String val, MatchMethod def) {
            try {
                return MatchMethod.valueOf(val.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                DietMod.LOGGER.error("No such match method " + val);
                return def;
            }
        }

        private static boolean inRange(float value, float above, float below) {
            return value >= above && value <= below;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum OriginsMatchMethod {
        ANY{

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            boolean matches(Set<String> input, Set<String> playerValues) {
                if (input == null) return true;
                if (!input.stream().anyMatch(playerValues::contains)) return false;
                return true;
            }
        }
        ,
        ALL{

            @Override
            boolean matches(Set<String> input, Set<String> playerValues) {
                return input == null || playerValues.containsAll(input);
            }
        }
        ,
        NONE{

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            boolean matches(Set<String> input, Set<String> playerValues) {
                if (input == null) return true;
                if (!input.stream().noneMatch(playerValues::contains)) return false;
                return true;
            }
        };


        abstract boolean matches(Set<String> var1, Set<String> var2);

        public static OriginsMatchMethod findOrDefault(String val, OriginsMatchMethod def) {
            try {
                return OriginsMatchMethod.valueOf(val.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                DietMod.LOGGER.error("No such origins match method " + val);
                return def;
            }
        }
    }

    public static class Condition {
        public final Set<String> groups;
        public final MatchMethod match;
        public final double above;
        public final double below;
        public final Set<String> origins;
        public final OriginsMatchMethod originsMatch;
        public final Set<String> powers;
        public final OriginsMatchMethod powersMatch;

        public Condition(Set<String> groups, MatchMethod match, double above, double below, Set<String> origins, OriginsMatchMethod originsMatch, Set<String> powers, OriginsMatchMethod powersMatch) {
            this.groups = groups;
            this.match = match;
            this.above = above;
            this.below = below;
            this.origins = origins;
            this.originsMatch = originsMatch;
            this.powers = powers;
            this.powersMatch = powersMatch;
        }

        public int getMatches(Player player, Map<String, Float> values) {
            return this.match.getMatches(this.groups, values, (float)this.above, (float)this.below);
        }
    }

    public static class DietStatusEffect {
        public final MobEffect effect;
        public final int power;

        public DietStatusEffect(MobEffect effect, int power) {
            this.effect = effect;
            this.power = power;
        }
    }

    public static class DietAttribute {
        public final Attribute attribute;
        public final AttributeModifier.Operation operation;
        public final double amount;

        public DietAttribute(Attribute attribute, AttributeModifier.Operation operation, double amount) {
            this.attribute = attribute;
            this.operation = operation;
            this.amount = amount;
        }
    }
}

