/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.common.network;

import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import top.theillusivec4.diet.api.IDietGroup;
import top.theillusivec4.diet.common.effect.DietEffectsInfo;
import top.theillusivec4.diet.common.network.server.SPacketActivate;
import top.theillusivec4.diet.common.network.server.SPacketDiet;
import top.theillusivec4.diet.common.network.server.SPacketEaten;
import top.theillusivec4.diet.common.network.server.SPacketEffectsInfo;
import top.theillusivec4.diet.common.network.server.SPacketGeneratedValues;

public class DietNetwork {
    private static final String PTC_VERSION = "1";
    public static SimpleChannel INSTANCE;
    private static int id;

    public static void setup() {
        INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("diet", "main")).networkProtocolVersion(() -> PTC_VERSION).clientAcceptedVersions(PTC_VERSION::equals).serverAcceptedVersions(PTC_VERSION::equals).simpleChannel();
        DietNetwork.register(SPacketDiet.class, SPacketDiet::encode, SPacketDiet::decode, SPacketDiet::handle);
        DietNetwork.register(SPacketEffectsInfo.class, SPacketEffectsInfo::encode, SPacketEffectsInfo::decode, SPacketEffectsInfo::handle);
        DietNetwork.register(SPacketActivate.class, SPacketActivate::encode, SPacketActivate::decode, SPacketActivate::handle);
        DietNetwork.register(SPacketGeneratedValues.class, SPacketGeneratedValues::encode, SPacketGeneratedValues::decode, SPacketGeneratedValues::handle);
        DietNetwork.register(SPacketEaten.class, SPacketEaten::encode, SPacketEaten::decode, SPacketEaten::handle);
    }

    public static void sendEffectsInfoS2C(ServerPlayer player, DietEffectsInfo info) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SPacketEffectsInfo(info));
    }

    public static void sendDietS2C(ServerPlayer player, Map<String, Float> groups) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SPacketDiet(groups));
    }

    public static void sendActivationS2C(ServerPlayer player, boolean flag) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SPacketActivate(flag));
    }

    public static void sendGeneratedValuesS2C(ServerPlayer player, Map<Item, Set<IDietGroup>> generated) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SPacketGeneratedValues(generated));
    }

    public static void sendEatenS2C(ServerPlayer player, Set<Item> items) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SPacketEaten(items));
    }

    private static <M> void register(Class<M> messageType, BiConsumer<M, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, M> decoder, BiConsumer<M, Supplier<NetworkEvent.Context>> messageConsumer) {
        INSTANCE.registerMessage(id++, messageType, encoder, decoder, messageConsumer);
    }

    static {
        id = 0;
    }
}

