/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.common.network.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.diet.api.IDietGroup;
import top.theillusivec4.diet.common.group.DietGroups;
import top.theillusivec4.diet.common.util.DietValueGenerator;

public class SPacketGeneratedValues {
    public final Map<Item, Set<IDietGroup>> generated;

    public SPacketGeneratedValues(Map<Item, Set<IDietGroup>> generated) {
        this.generated = generated;
    }

    public static void encode(SPacketGeneratedValues msg, FriendlyByteBuf buf) {
        CompoundTag compoundNBT = new CompoundTag();
        for (Map.Entry<Item, Set<IDietGroup>> entry : msg.generated.entrySet()) {
            ListTag listNBT = new ListTag();
            for (IDietGroup group : entry.getValue()) {
                listNBT.add((Object)StringTag.m_129297_((String)group.getName()));
            }
            compoundNBT.m_128365_(Objects.requireNonNull(entry.getKey().getRegistryName()).toString(), (Tag)listNBT);
        }
        buf.m_130079_(compoundNBT);
    }

    public static SPacketGeneratedValues decode(FriendlyByteBuf buf) {
        CompoundTag compoundNBT = buf.m_130260_();
        HashMap<Item, Set<IDietGroup>> generated = new HashMap<Item, Set<IDietGroup>>();
        HashMap<String, IDietGroup> groups = new HashMap<String, IDietGroup>();
        for (IDietGroup group : DietGroups.get()) {
            groups.put(group.getName(), group);
        }
        if (compoundNBT != null) {
            for (String name : compoundNBT.m_128431_()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
                if (item == null) continue;
                ListTag listNBT = compoundNBT.m_128437_(name, 8);
                HashSet<IDietGroup> found = new HashSet<IDietGroup>();
                for (Tag nbt : listNBT) {
                    String entry = nbt.m_7916_();
                    IDietGroup group = (IDietGroup)groups.get(entry);
                    if (group == null) continue;
                    found.add(group);
                }
                generated.put(item, found);
            }
        }
        return new SPacketGeneratedValues(generated);
    }

    public static void handle(SPacketGeneratedValues msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DietValueGenerator.sync(msg));
        ctx.get().setPacketHandled(true);
    }
}

