/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.common.util;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;
import top.theillusivec4.diet.DietMod;
import top.theillusivec4.diet.api.IDietGroup;
import top.theillusivec4.diet.common.config.DietServerConfig;
import top.theillusivec4.diet.common.group.DietGroups;
import top.theillusivec4.diet.common.network.DietNetwork;
import top.theillusivec4.diet.common.network.server.SPacketGeneratedValues;

public class DietValueGenerator {
    private static final Map<Item, Set<IDietGroup>> GENERATED = new HashMap<Item, Set<IDietGroup>>();
    private static final Map<Item, List<Item>> TRAILS = new HashMap<Item, List<Item>>();
    private static final Comparator<ItemStack> COMPARATOR = new IngredientComparator();
    private static final ITagManager<Item> ITEM_TAGS = ForgeRegistries.ITEMS.tags();
    private static final TagKey<Item> INGREDIENTS = ITEM_TAGS != null ? ITEM_TAGS.createTagKey(new ResourceLocation(DietMod.id("ingredients"))) : null;
    private static final TagKey<Item> SPECIAL_FOOD = ITEM_TAGS != null ? ITEM_TAGS.createTagKey(new ResourceLocation(DietMod.id("special_food"))) : null;
    private static final Set<Item> UNGROUPED = new HashSet<Item>();
    private static final Map<Item, List<Recipe<?>>> RECIPES = new HashMap();
    private static final Set<Item> PROCESSED = new HashSet<Item>();

    public static void setup() {
        MinecraftForge.EVENT_BUS.addListener(DietValueGenerator::onDatapackSync);
        MinecraftForge.EVENT_BUS.addListener(DietValueGenerator::serverStarting);
    }

    private static void onDatapackSync(OnDatapackSyncEvent evt) {
        if (evt.getPlayer() == null) {
            DietValueGenerator.reload(evt.getPlayerList().m_7873_());
        } else {
            DietValueGenerator.sync(evt.getPlayer());
        }
    }

    private static void serverStarting(ServerStartingEvent evt) {
        DietValueGenerator.reload(evt.getServer());
    }

    public static void reload(MinecraftServer server) {
        GENERATED.clear();
        TRAILS.clear();
        if (DietServerConfig.generateGroupsForEmptyItems) {
            DietMod.LOGGER.info("Generating diet values...");
            Stopwatch stopwatch = Stopwatch.createUnstarted();
            stopwatch.reset();
            stopwatch.start();
            Set<IDietGroup> groups = DietGroups.get();
            DietValueGenerator.findUngroupedFoods(groups);
            RecipeManager recipeManager = server.m_129894_();
            DietValueGenerator.findAllRecipesForItems(recipeManager);
            DietValueGenerator.processItems(groups);
            stopwatch.stop();
            DietMod.LOGGER.info("Generating diet values took {}", (Object)stopwatch);
        }
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            DietNetwork.sendGeneratedValuesS2C(player, GENERATED);
        }
    }

    private static void processItems(Set<IDietGroup> groups) {
        DietMod.LOGGER.info("Processing items...");
        PROCESSED.clear();
        for (Item item : UNGROUPED) {
            if (PROCESSED.contains(item)) continue;
            ArrayList<Item> trail = new ArrayList<Item>();
            DietValueGenerator.findGroups(groups, item, trail);
        }
        DietMod.LOGGER.info("Processed {} items", (Object)PROCESSED.size());
    }

    private static Set<IDietGroup> findGroups(Set<IDietGroup> groups, Item targetItem, List<Item> trail) {
        List<Recipe<?>> list;
        PROCESSED.add(targetItem);
        HashSet<IDietGroup> result = new HashSet<IDietGroup>();
        ItemStack proxy = new ItemStack((ItemLike)targetItem);
        for (IDietGroup group : groups) {
            if (!group.contains(proxy)) continue;
            result.add(group);
        }
        if (result.isEmpty() && (list = RECIPES.get(targetItem)) != null) {
            HashSet<IDietGroup> found = new HashSet<IDietGroup>();
            for (Recipe<?> recipe : list) {
                HashSet<Item> keys = new HashSet<Item>();
                block2: for (Ingredient ingredient : recipe.m_7527_()) {
                    ItemStack[] itemStacks = (ItemStack[])ingredient.m_43908_().clone();
                    if (itemStacks.length == 0) continue;
                    Arrays.sort(itemStacks, COMPARATOR);
                    for (int i = 0; i < itemStacks.length; ++i) {
                        ArrayList<Item> subTrail;
                        ItemStack stack = itemStacks[i];
                        Item item = stack.m_41720_();
                        if (i == 0) {
                            if (keys.contains(item)) continue block2;
                            keys.add(item);
                        }
                        if (ITEM_TAGS != null && ITEM_TAGS.getTag(INGREDIENTS).contains((Object)item)) continue;
                        Set<IDietGroup> fallback = GENERATED.get(item);
                        boolean addTrail = false;
                        if (fallback != null) {
                            found.addAll(fallback);
                            addTrail = !fallback.isEmpty();
                        } else if (!PROCESSED.contains(item)) {
                            subTrail = new ArrayList();
                            HashSet<IDietGroup> pending = new HashSet<IDietGroup>(DietValueGenerator.findGroups(groups, item, subTrail));
                            found.addAll(pending);
                            GENERATED.putIfAbsent(item, pending);
                            TRAILS.putIfAbsent(item, subTrail);
                            boolean bl = addTrail = !pending.isEmpty();
                        }
                        if (addTrail && (subTrail = TRAILS.get(item)) != null) {
                            trail.add(item);
                            trail.addAll(subTrail);
                        }
                        if (!found.isEmpty()) continue block2;
                    }
                }
                if (found.isEmpty()) continue;
                break;
            }
            result.addAll(found);
        }
        GENERATED.putIfAbsent(targetItem, result);
        TRAILS.putIfAbsent(targetItem, trail);
        return result;
    }

    private static void findAllRecipesForItems(RecipeManager recipeManager) {
        DietMod.LOGGER.info("Building item-to-recipes map...");
        RECIPES.clear();
        HashMap<Item, List> result = new HashMap<Item, List>();
        for (Recipe recipe : recipeManager.m_44051_()) {
            ItemStack output = ItemStack.f_41583_;
            try {
                output = recipe.m_8043_();
            }
            catch (Exception e) {
                DietMod.LOGGER.error("Diet was unable to process recipe: {}", (Object)recipe.m_6423_());
            }
            if (output == null) {
                DietMod.LOGGER.debug("Diet was unable to process recipe due to null output: {}", (Object)recipe.m_6423_());
                continue;
            }
            Item item = output.m_41720_();
            List current = result.computeIfAbsent(item, k -> new ArrayList());
            current.add(recipe);
        }
        for (List list : result.values()) {
            if (list.size() <= 1) continue;
            list.sort(Comparator.comparing(Recipe::m_6423_));
        }
        RECIPES.putAll(result);
        DietMod.LOGGER.info("Found {} valid items with recipes", (Object)RECIPES.size());
    }

    private static void findUngroupedFoods(Set<IDietGroup> groups) {
        DietMod.LOGGER.info("Finding ungrouped food items...");
        UNGROUPED.clear();
        HashSet<Item> result = new HashSet<Item>();
        block0: for (Item item : ForgeRegistries.ITEMS) {
            ItemStack stack = item.m_7968_();
            FoodProperties food = stack.getFoodProperties(null);
            if ((food == null || food.m_38744_() <= 0) && (ITEM_TAGS == null || !ITEM_TAGS.getTag(SPECIAL_FOOD).contains((Object)item))) continue;
            for (IDietGroup group : groups) {
                if (!group.contains(new ItemStack((ItemLike)item))) continue;
                continue block0;
            }
            result.add(item);
        }
        UNGROUPED.addAll(result);
        DietMod.LOGGER.info("Found {} ungrouped food items", (Object)UNGROUPED.size());
    }

    public static void sync(ServerPlayer player) {
        DietNetwork.sendGeneratedValuesS2C(player, GENERATED);
    }

    public static void sync(SPacketGeneratedValues packet) {
        GENERATED.clear();
        GENERATED.putAll(packet.generated);
    }

    public static Optional<Set<IDietGroup>> get(Item item) {
        return Optional.ofNullable(GENERATED.get(item));
    }

    public static List<Item> getTrail(Item item) {
        return TRAILS.getOrDefault(item, Collections.emptyList());
    }

    private static class IngredientComparator
    implements Comparator<ItemStack> {
        private IngredientComparator() {
        }

        @Override
        public int compare(ItemStack o1, ItemStack o2) {
            ResourceLocation rl1 = o1.m_41720_().getRegistryName();
            ResourceLocation rl2 = o2.m_41720_().getRegistryName();
            if (rl1 == null) {
                return 1;
            }
            if (rl2 == null) {
                return -1;
            }
            String namespace1 = rl1.m_135827_();
            String namespace2 = rl2.m_135827_();
            if (namespace1.equals("minecraft") && !namespace2.equals("minecraft")) {
                return -1;
            }
            if (namespace2.equals("minecraft") && !namespace1.equals("minecraft")) {
                return 1;
            }
            return rl1.compareNamespaced(rl2);
        }
    }
}

