/*
 * Decompiled with CFR 0.152.
 */
package com.daderpduck.seamless_loading_screen;

import com.daderpduck.seamless_loading_screen.SeamlessLoadingScreen;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class ScreenshotLoader {
    public static final ResourceLocation SCREENSHOT = new ResourceLocation("seamless_loading_screen", "screenshot");
    private static float imageRatio = 1.0f;
    private static boolean loaded = false;
    private static Path filePath;
    private static final Pattern RESERVED_FILENAMES_PATTERN;

    public static void setScreenshotWorld(String worldName) {
        ScreenshotLoader.setScreenshot("screenshots/worlds/singleplayer/" + worldName + ".png");
    }

    public static void setScreenshotServer(String address, int port) {
        ScreenshotLoader.setScreenshot("screenshots/worlds/servers/" + address + "_" + port + ".png");
    }

    public static void setScreenshotRealm(String realmName) {
        ScreenshotLoader.setScreenshot("screenshots/worlds/realms/" + ScreenshotLoader.cleanFileName(realmName) + ".png");
    }

    private static void setScreenshot(String screenshotPath) {
        loaded = false;
        filePath = Paths.get(Minecraft.m_91087_().f_91069_.getPath(), screenshotPath);
        if (Files.isRegularFile(filePath, new LinkOption[0])) {
            try (FileInputStream in = new FileInputStream(filePath.toFile());){
                NativeImage image = NativeImage.m_85058_((InputStream)in);
                imageRatio = (float)image.m_84982_() / (float)image.m_85084_();
                Minecraft.m_91087_().m_91097_().m_118495_(SCREENSHOT, (AbstractTexture)new DynamicTexture(image));
                loaded = true;
                SeamlessLoadingScreen.LOGGER.info("Screenshot loaded at {}", (Object)filePath);
            }
            catch (IOException e) {
                SeamlessLoadingScreen.LOGGER.error("Failed to read screenshot", (Throwable)e);
            }
        } else {
            SeamlessLoadingScreen.LOGGER.warn("Screenshot path doesn't exist or is not a file {}", (Object)filePath);
        }
    }

    private static String cleanFileName(String fileName) {
        for (char c : SharedConstants.f_136184_) {
            fileName = ((String)fileName).replace(c, '_');
        }
        if (RESERVED_FILENAMES_PATTERN.matcher((CharSequence)(fileName = ((String)fileName).replaceAll("[./\"]", "_"))).matches()) {
            fileName = "_" + (String)fileName + "_";
        }
        if (((String)fileName).length() > 251) {
            fileName = ((String)fileName).substring(0, 251);
        }
        return fileName;
    }

    public static float getImageRatio() {
        return imageRatio;
    }

    public static Path getCurrentScreenshotPath() {
        return filePath;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static void resetState() {
        loaded = false;
    }

    static {
        RESERVED_FILENAMES_PATTERN = Pattern.compile(".*\\.|(?:COM|CLOCK\\$|CON|PRN|AUX|NUL|COM[1-9]|LPT[1-9])(?:\\..*)?", 2);
    }
}

