/*
 * Decompiled with CFR 0.152.
 */
package ht.treeplant.server.config;

import ht.treeplant.server.config.ConfigHandler;
import java.util.Collections;
import java.util.Optional;
import net.minecraftforge.common.ForgeConfigSpec;

public class PlantingConfig {
    private final ForgeConfigSpec.DoubleValue numSecondsBeforePlanting;
    private final ForgeConfigSpec.DoubleValue wiggle;
    private final ForgeConfigSpec.IntValue minDistanceBetweenSaplings;
    private final ForgeConfigSpec.DoubleValue chanceOfPlanting;
    private int bakedNumTicksBeforePlanting;
    private int bakedWiggleTicks;
    private int bakedMinDistanceBetweenSaplings;
    private double bakedChanceToTryPlanting;

    protected PlantingConfig(ForgeConfigSpec.Builder builder, String description, Double defaultNumSecondsBeforePlanting, Double defaultWiggle, Double defaultChanceOfPlanting, Integer defaultMinDistanceBetweenSaplings) {
        builder.push(Collections.singletonList(description));
        this.numSecondsBeforePlanting = defaultNumSecondsBeforePlanting != null ? builder.comment("The number of seconds to wait before planting saplings").defineInRange("numSecondsBeforePlanting", defaultNumSecondsBeforePlanting.doubleValue(), 0.0, 100000.0) : null;
        this.wiggle = defaultWiggle != null ? builder.comment("A random number of seconds to add to the wait time").defineInRange("wiggle", defaultWiggle.doubleValue(), 0.0, 100000.0) : null;
        this.chanceOfPlanting = defaultChanceOfPlanting != null ? builder.comment("Chance that a dropped sapling will be planted if possible").defineInRange("chanceOfPlanting", defaultChanceOfPlanting.doubleValue(), 0.0, 1.0) : null;
        this.minDistanceBetweenSaplings = defaultMinDistanceBetweenSaplings != null ? builder.comment("The minimum allowed distance between saplings of the same type").defineInRange("minDistanceBetweenSaplings", defaultMinDistanceBetweenSaplings.intValue(), 1, 16) : null;
        builder.pop();
    }

    public void refresh() {
        this.bakedNumTicksBeforePlanting = ConfigHandler.secondsToTicks(this.getConfigValue((ForgeConfigSpec.ConfigValue)this.numSecondsBeforePlanting).orElse(0.0));
        this.bakedWiggleTicks = ConfigHandler.secondsToTicks(this.getConfigValue((ForgeConfigSpec.ConfigValue)this.wiggle).orElse(0.0));
        this.bakedMinDistanceBetweenSaplings = this.getConfigValue((ForgeConfigSpec.ConfigValue)this.minDistanceBetweenSaplings).orElse(0);
        this.bakedChanceToTryPlanting = this.getConfigValue((ForgeConfigSpec.ConfigValue)this.chanceOfPlanting).orElse(0.0);
    }

    private <T extends Number> Optional<T> getConfigValue(ForgeConfigSpec.ConfigValue<T> numSecondsBeforePlanting) {
        return numSecondsBeforePlanting != null ? Optional.of((Number)numSecondsBeforePlanting.get()) : Optional.empty();
    }

    public int getNumTicksBeforePlanting() {
        return this.bakedNumTicksBeforePlanting;
    }

    public int getMinDistanceBetweenSaplings() {
        return this.bakedMinDistanceBetweenSaplings;
    }

    public double getChanceOfPlanting() {
        return this.bakedChanceToTryPlanting;
    }

    public int getWiggle() {
        return this.bakedWiggleTicks;
    }
}

