/*
 * Decompiled with CFR 0.152.
 */
package ht.treeplant.server.event;

import ht.treeplant.server.config.ConfigHandler;
import ht.treeplant.server.config.PlantingConfig;
import ht.treeplant.server.util.ItemEntityWatcher;
import ht.treeplant.server.util.PlantUtil;
import java.util.PriorityQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AutoPlant {
    private static PriorityQueue<ItemEntityWatcher> watchers = new PriorityQueue();
    private static long tick = 0L;
    private static ItemEntity lastTossedItem;
    private static BlockPos lastBrokenPos;

    public static void init() {
        if (ConfigHandler.COMMON.brokenSaplings.getChanceOfPlanting() > 0.0 || ConfigHandler.COMMON.tossedSaplings.getChanceOfPlanting() > 0.0 || ConfigHandler.COMMON.naturalSaplings.getChanceOfPlanting() > 0.0) {
            MinecraftForge.EVENT_BUS.addListener(AutoPlant::watchItemEntities);
            MinecraftForge.EVENT_BUS.addListener(AutoPlant::detectPlayerToss);
            MinecraftForge.EVENT_BUS.addListener(AutoPlant::detectPlayerBlockBreak);
        }
        if (ConfigHandler.COMMON.despawningSaplings.getChanceOfPlanting() > 0.0) {
            MinecraftForge.EVENT_BUS.addListener(AutoPlant::plantOnDespawn);
        }
        if (!ConfigHandler.allowPlantingWithRightClick) {
            MinecraftForge.EVENT_BUS.addListener(AutoPlant::preventManualPlanting);
        }
    }

    private static void plantOnDespawn(ItemExpireEvent event) {
        ItemEntity entity = event.getEntityItem();
        if (AutoPlant.itemStackIsPlantable(entity.m_32055_()) && PlantUtil.randomlyWantsToPlant(ConfigHandler.COMMON.despawningSaplings)) {
            PlantUtil.tryToPlant(entity);
        }
    }

    public static void detectPlayerToss(ItemTossEvent event) {
        lastTossedItem = event.getEntityItem();
    }

    public static void detectPlayerBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() != null) {
            lastBrokenPos = event.getPos();
        }
    }

    public static void preventManualPlanting(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getPlayer().m_7500_() && AutoPlant.itemStackIsPlantable(event.getItemStack())) {
            event.setUseItem(Event.Result.DENY);
        }
    }

    public static void watchItemEntities(EntityJoinWorldEvent event) {
        PlantingConfig plantingConfig;
        ItemStack itemStack;
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity && AutoPlant.itemStackIsPlantable(itemStack = ((ItemEntity)entity).m_32055_()) && PlantUtil.randomlyWantsToPlant(plantingConfig = entity == lastTossedItem ? ConfigHandler.COMMON.tossedSaplings : (entity.m_142538_().equals((Object)lastBrokenPos) ? ConfigHandler.COMMON.brokenSaplings : ConfigHandler.COMMON.naturalSaplings))) {
            AutoPlant.watch((ItemEntity)entity, plantingConfig);
        }
    }

    public static boolean itemStackIsPlantable(ItemStack itemStack) {
        return !itemStack.m_41619_() && itemStack.m_204117_(ConfigHandler.itemTagForSaplings);
    }

    public static void watch(ItemEntity itemEntity, PlantingConfig plantingConfig) {
        AutoPlant.watch(new ItemEntityWatcher(itemEntity, tick, plantingConfig));
    }

    public static void watch(ItemEntityWatcher watcher) {
        if (!TickHandler.isRegistered) {
            MinecraftForge.EVENT_BUS.register(TickHandler.class);
            TickHandler.isRegistered = true;
        }
        watchers.add(watcher);
    }

    private static class TickHandler {
        protected static boolean isRegistered = false;

        private TickHandler() {
        }

        @SubscribeEvent
        public static void onTick(TickEvent.ServerTickEvent event) {
            if (!watchers.isEmpty()) {
                ItemEntityWatcher top;
                ++tick;
                while ((top = watchers.peek()) != null && top.getTick() <= tick) {
                    watchers.poll();
                    top.activate();
                }
            } else {
                tick = 0L;
                MinecraftForge.EVENT_BUS.unregister(TickHandler.class);
                isRegistered = false;
            }
            lastBrokenPos = null;
        }
    }
}

