/*
 * Decompiled with CFR 0.152.
 */
package ht.treeplant.server.util;

import ht.treeplant.TreePlant;
import ht.treeplant.server.config.PlantingConfig;
import ht.treeplant.server.util.RandomUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class PlantUtil {
    public static boolean tryToPlant(ItemEntity itemEntity) {
        ItemStack itemStack = itemEntity.m_32055_();
        Item item = itemStack.m_41720_();
        if (item instanceof BlockItem) {
            InteractionResult result = ((BlockItem)item).m_40576_((BlockPlaceContext)new DirectionalPlaceContext(itemEntity.m_183503_(), itemEntity.m_142538_(), Direction.DOWN, itemStack, Direction.UP));
            return result == InteractionResult.SUCCESS;
        }
        TreePlant.LOGGER.warn("I don't know how to plant " + item.getRegistryName() + " (" + item.getClass().getName() + " is not an instance of " + BlockItem.class.getName() + ")");
        return false;
    }

    public static boolean noNearbyBlocksOfType(Level level, BlockPos pos, Block block, int minDistanceBetweenSaplings) {
        int dis = minDistanceBetweenSaplings - 1;
        for (int x = -dis; x <= dis; ++x) {
            for (int z = -dis; z <= dis; ++z) {
                if (level.m_8055_(pos.m_142082_(x, 0, z)).m_60734_() != block) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean randomlyWantsToPlant(PlantingConfig plantingConfig) {
        return RandomUtil.get(1.0) <= plantingConfig.getChanceOfPlanting();
    }

    public static boolean noNearbySaplings(ItemEntity itemEntity, PlantingConfig plantingConfig) {
        Item item = itemEntity.m_32055_().m_41720_();
        if (item instanceof BlockItem) {
            return PlantUtil.noNearbyBlocksOfType(itemEntity.m_183503_(), itemEntity.m_142538_(), ((BlockItem)item).m_40614_(), plantingConfig.getMinDistanceBetweenSaplings());
        }
        return false;
    }
}

