/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.client.model.geo;

import com.github.eterdelta.crittersandcompanions.entity.RedPandaEntity;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class RedPandaModel
extends AnimatedGeoModel<RedPandaEntity> {
    private static final ResourceLocation[] MODELS = new ResourceLocation[]{new ResourceLocation("crittersandcompanions", "geo/red_panda.geo.json"), new ResourceLocation("crittersandcompanions", "geo/baby_red_panda.geo.json")};
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("crittersandcompanions", "textures/entity/red_panda.png"), new ResourceLocation("crittersandcompanions", "textures/entity/red_panda_sleeping.png"), new ResourceLocation("crittersandcompanions", "textures/entity/baby_red_panda.png")};
    private static final ResourceLocation[] ANIMATIONS = new ResourceLocation[]{new ResourceLocation("crittersandcompanions", "animations/red_panda.animation.json"), new ResourceLocation("crittersandcompanions", "animations/baby_red_panda.animation.json")};

    public ResourceLocation getModelLocation(RedPandaEntity object) {
        return MODELS[object.m_6162_() ? 1 : 0];
    }

    public ResourceLocation getTextureLocation(RedPandaEntity object) {
        return TEXTURES[object.m_6162_() ? 2 : (object.m_5803_() ? 1 : 0)];
    }

    public ResourceLocation getAnimationFileLocation(RedPandaEntity animatable) {
        return ANIMATIONS[animatable.m_6162_() ? 1 : 0];
    }

    public void setLivingAnimations(RedPandaEntity entity, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone headBone = this.getAnimationProcessor().getBone("head");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (!entity.m_5803_()) {
            if (!entity.isAlert()) {
                headBone.setRotationX(extraData.headPitch * ((float)Math.PI / 180));
            }
            headBone.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180));
        }
    }
}

