/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.mixin;

import com.github.eterdelta.crittersandcompanions.item.PearlNecklaceItem;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @ModifyVariable(at=@At(value="STORE", ordinal=0), method={"travel(Lnet/minecraft/world/phys/Vec3;)V"}, ordinal=1)
    private float modifySwimSpeed(float swimSpeed) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player) {
            Player player = (Player)livingEntityMixin;
            Inventory inventory = player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack stack = inventory.m_8020_(i);
                Item item = stack.m_41720_();
                if (!(item instanceof PearlNecklaceItem)) continue;
                PearlNecklaceItem pearlNecklaceItem = (PearlNecklaceItem)item;
                return swimSpeed + swimSpeed * ((float)(pearlNecklaceItem.getLevel() * 20) / 100.0f);
            }
        }
        return swimSpeed;
    }
}

