/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.api.registry;

import dev.momostudios.coldsweat.ColdSweat;
import dev.momostudios.coldsweat.api.temperature.block_temp.BlockTemp;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockTempRegistry {
    public static final LinkedList<BlockTemp> BLOCK_EFFECTS = new LinkedList();
    public static final HashMap<Block, BlockTemp> MAPPED_BLOCKS = new HashMap();
    public static final BlockTemp DEFAULT_BLOCK_EFFECT = new BlockTemp(new Block[0]){

        @Override
        public double getTemperature(Player player, BlockState state, BlockPos pos, double distance) {
            return 0.0;
        }
    };

    public static void register(BlockTemp blockTemp) {
        blockTemp.validBlocks.forEach(block -> {
            if (MAPPED_BLOCKS.containsKey(block)) {
                ColdSweat.LOGGER.error("Block \"{}\" already has a registered BlockTemp ({})! Skipping BlockTemp {}...", (Object)block.getRegistryName().toString(), (Object)MAPPED_BLOCKS.get(block).getClass().getSimpleName(), (Object)blockTemp.getClass().getSimpleName());
            } else {
                MAPPED_BLOCKS.put((Block)block, blockTemp);
            }
        });
        BLOCK_EFFECTS.add(blockTemp);
    }

    public static void flush() {
        MAPPED_BLOCKS.clear();
    }

    public static BlockTemp getEntryFor(BlockState blockstate) {
        if (blockstate.m_60795_()) {
            return DEFAULT_BLOCK_EFFECT;
        }
        return MAPPED_BLOCKS.computeIfAbsent(blockstate.m_60734_(), block -> DEFAULT_BLOCK_EFFECT);
    }
}

