/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.api.temperature.modifier;

import com.mojang.datafixers.util.Pair;
import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.api.temperature.modifier.TempModifier;
import dev.momostudios.coldsweat.util.LegacyMethodHelper;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import dev.momostudios.coldsweat.util.math.CSMath;
import dev.momostudios.coldsweat.util.world.WorldHelper;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;

public class BiomeTempModifier
extends TempModifier {
    static int SAMPLES = 64;

    @Override
    public Function<Temperature, Temperature> calculate(Player player) {
        try {
            double worldTemp = 0.0;
            ResourceLocation dimensionID = player.f_19853_.m_46472_().m_135782_();
            Number dimensionOverride = ConfigSettings.DIMENSION_TEMPS.get().get(dimensionID);
            if (dimensionOverride != null) {
                return temp -> temp.add(dimensionOverride.doubleValue());
            }
            double time = Math.sin((double)player.f_19853_.m_46468_() / 3819.7186342054883);
            for (BlockPos blockPos : WorldHelper.getNearbyPositions(player.m_142538_(), SAMPLES, 16)) {
                Biome biome = LegacyMethodHelper.getBiome(player.f_19853_, blockPos);
                if (biome == null) continue;
                ResourceLocation biomeID = biome.getRegistryName();
                double biomeVariance = 1.0f / Math.max(1.0f, 2.0f + biome.m_47548_() * 2.0f);
                double biomeTemp = biome.m_47554_();
                Pair<Double, Double> configTemp = ConfigSettings.BIOME_OFFSETS.get().getOrDefault(biomeID, (Pair<Double, Double>)Pair.of((Object)0.0, (Object)0.0));
                configTemp = ConfigSettings.BIOME_TEMPS.get().getOrDefault(biomeID, (Pair<Double, Double>)Pair.of((Object)((Double)configTemp.getFirst() + biomeTemp - biomeVariance), (Object)((Double)configTemp.getSecond() + biomeTemp + biomeVariance)));
                double min = (Double)configTemp.getFirst();
                double max = (Double)configTemp.getSecond();
                DimensionType dimension = player.f_19853_.m_6042_();
                if (!dimension.m_63946_()) {
                    worldTemp += CSMath.blend(min, max, time, -1.0, 1.0) / (double)SAMPLES;
                    continue;
                }
                worldTemp += CSMath.average(max, min) / (double)SAMPLES;
            }
            double finalWorldTemp = worldTemp += ConfigSettings.DIMENSION_OFFSETS.get().getOrDefault(dimensionID, 0.0).doubleValue();
            return temp -> temp.add(finalWorldTemp);
        }
        catch (Exception e) {
            return temp -> temp;
        }
    }

    @Override
    public String getID() {
        return "cold_sweat:biome_temperature";
    }
}

