/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.api.temperature.modifier;

import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.api.temperature.modifier.TempModifier;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import dev.momostudios.coldsweat.util.math.CSMath;
import dev.momostudios.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;

public class DepthTempModifier
extends TempModifier {
    static int SAMPLES = 25;

    @Override
    public Function<Temperature, Temperature> calculate(Player player) {
        if (player.f_19853_.m_6042_().m_63946_()) {
            return temp -> temp;
        }
        double midTemp = (ConfigSettings.getInstance().maxTemp + ConfigSettings.getInstance().minTemp) / 2.0;
        BlockPos playerPos = player.m_142538_();
        ArrayList<Double> lightLevels = new ArrayList<Double>();
        ArrayList<Double> depthLevels = new ArrayList<Double>();
        for (BlockPos pos : WorldHelper.getNearbyPositions(playerPos, SAMPLES, 3)) {
            ChunkAccess chunk = player.f_19853_.m_6522_(pos.m_123341_() >> 4, pos.m_123343_() >> 4, ChunkStatus.f_62319_, false);
            if (chunk == null) continue;
            double depth = Math.max(0, chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_()) - playerPos.m_123342_());
            double light = player.f_19853_.m_45517_(LightLayer.SKY, pos);
            lightLevels.add(light);
            depthLevels.add(depth);
        }
        double light = CSMath.average(lightLevels.toArray(new Double[0]));
        double depth = CSMath.average(depthLevels.toArray(new Double[0]));
        return temp -> {
            HashMap<Double, Double> valueMap = new HashMap<Double, Double>();
            valueMap.put(temp.get(), 0.8);
            valueMap.put(CSMath.blend(midTemp, temp.get(), light, 0.0, 15.0), 2.0);
            valueMap.put(CSMath.blend(temp.get(), midTemp, depth, 4.0, 20.0), 4.0);
            return new Temperature(CSMath.weightedAverage(valueMap));
        };
    }

    @Override
    public String getID() {
        return "cold_sweat:depth";
    }
}

