/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.api.temperature.modifier;

import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.api.temperature.modifier.TempModifier;
import dev.momostudios.coldsweat.api.util.TempHelper;
import dev.momostudios.coldsweat.config.ColdSweatConfig;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import dev.momostudios.coldsweat.util.math.CSMath;
import java.util.function.Function;
import net.minecraft.world.entity.player.Player;

public class HearthTempModifier
extends TempModifier {
    public HearthTempModifier() {
        this.addArgument("strength", 0);
    }

    public HearthTempModifier(int strength) {
        this.addArgument("strength", strength);
    }

    @Override
    public Function<Temperature, Temperature> calculate(Player player) {
        double worldTemp = TempHelper.getTemperature(player, Temperature.Type.WORLD).get();
        player.getPersistentData().m_128347_("preHearthTemp", worldTemp);
        ConfigSettings config = ConfigSettings.getInstance();
        double min = config.minTemp;
        double max = config.maxTemp;
        double mid = (min + max) / 2.0;
        double hearthStrength = ColdSweatConfig.getInstance().getHearthEffect();
        int insulationStrength = (Integer)this.getArgument("strength");
        return temp -> new Temperature(CSMath.blend(temp.get(), CSMath.weightedAverage(temp.get(), mid, 1.0 - hearthStrength, 1.0), (double)insulationStrength, 0.0, 10.0));
    }

    @Override
    public String getID() {
        return "cold_sweat:hearth_insulation";
    }
}

