/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.api.temperature.modifier;

import dev.momostudios.coldsweat.api.event.common.TempModifierEvent;
import dev.momostudios.coldsweat.api.temperature.Temperature;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public abstract class TempModifier {
    ConcurrentHashMap<String, Object> args = new ConcurrentHashMap();
    int expireTicks = -1;
    int ticksExisted = 0;
    int tickRate = 1;
    Temperature lastInput = new Temperature();
    Temperature lastOutput = new Temperature();
    Function<Temperature, Temperature> function = temp -> temp;

    public void addArgument(String name, Object arg) {
        this.args.put(name, arg);
    }

    public <T> T getArgument(String name) {
        return (T)this.args.get(name);
    }

    public void setArgument(String name, Object arg) {
        try {
            this.args.put(name, arg);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Argument type mismatch trying to set argument \"" + name + "\" of " + this.getID() + " to " + arg + " (expected " + this.args.get(name).getClass().getName() + ")");
        }
    }

    public void clearArgument(String name) {
        this.args.remove(name);
    }

    public final Map<String, Object> getArguments() {
        return this.args;
    }

    protected abstract Function<Temperature, Temperature> calculate(Player var1);

    public Temperature update(Temperature temp, Player player) {
        TempModifierEvent.Calculate.Pre pre = new TempModifierEvent.Calculate.Pre(this, player, temp);
        MinecraftForge.EVENT_BUS.post((Event)pre);
        if (pre.isCanceled()) {
            return temp;
        }
        this.function = this.calculate(player);
        TempModifierEvent.Calculate.Post post = new TempModifierEvent.Calculate.Post(this, player, this.getResult(pre.getTemperature()));
        MinecraftForge.EVENT_BUS.post((Event)post);
        return post.getTemperature();
    }

    public Temperature getResult(Temperature temp) {
        this.lastInput = temp.copy();
        this.lastOutput = this.function.apply(temp).copy();
        return this.lastOutput;
    }

    public TempModifier expires(int ticks) {
        this.expireTicks = ticks;
        return this;
    }

    public int getExpireTime() {
        return this.expireTicks;
    }

    public int getTicksExisted() {
        return this.ticksExisted;
    }

    public int setTicksExisted(int ticks) {
        this.ticksExisted = ticks;
        return this.ticksExisted;
    }

    public TempModifier tickRate(int ticks) {
        this.tickRate = Math.max(1, ticks);
        return this;
    }

    public int getTickRate() {
        return this.tickRate;
    }

    public Temperature getLastInput() {
        return this.lastInput;
    }

    public Temperature getLastOutput() {
        return this.lastOutput;
    }

    public abstract String getID();

    public String toString() {
        return this.getID();
    }
}

