/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.client.event;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import dev.momostudios.coldsweat.api.event.client.RenderLevelEvent;
import dev.momostudios.coldsweat.common.blockentity.HearthBlockEntity;
import dev.momostudios.coldsweat.common.event.HearthPathManagement;
import dev.momostudios.coldsweat.config.ClientSettingsConfig;
import dev.momostudios.coldsweat.util.math.CSMath;
import dev.momostudios.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class HearthDebugRenderer {
    public static Map<BlockPos, Set<Pair<BlockPos, ArrayList<Direction>>>> HEARTH_LOCATIONS = new HashMap<BlockPos, Set<Pair<BlockPos, ArrayList<Direction>>>>();

    @SubscribeEvent
    public static void onLevelRendered(RenderLevelEvent event) {
        if (Minecraft.m_91087_().f_91066_.f_92063_ && ClientSettingsConfig.getInstance().hearthDebug()) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            Frustum frustum = event.getFrustum();
            PoseStack ps = event.getPoseStack();
            Vec3 camPos = event.getCamera().m_90583_();
            Level level = event.getLevel();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            VertexConsumer vertexes = buffer.m_6299_((RenderType)RenderType.f_110371_);
            ps.m_85836_();
            ps.m_85837_(-camPos.f_82479_, -camPos.f_82480_, -camPos.f_82481_);
            Matrix4f matrix4f = ps.m_85850_().m_85861_();
            Matrix3f matrix3f = ps.m_85850_().m_85864_();
            BiConsumer<Vector3f, Float> nw = (pos, renderAlpha) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_(), pos.m_122269_()).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_() + 1.0f, pos.m_122269_()).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            };
            BiConsumer<Vector3f, Float> ne = (pos, renderAlpha) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_(), pos.m_122269_()).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_() + 1.0f, pos.m_122269_()).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            };
            BiConsumer<Vector3f, Float> sw = (pos, renderAlpha) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_(), pos.m_122269_() + 1.0f).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_() + 1.0f, pos.m_122269_() + 1.0f).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            };
            BiConsumer<Vector3f, Float> se = (pos, renderAlpha) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_(), pos.m_122269_() + 1.0f).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_() + 1.0f, pos.m_122269_() + 1.0f).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            };
            BiConsumer<Vector3f, Float> nu = (pos, renderAlpha) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_() + 1.0f, pos.m_122269_()).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_() + 1.0f, pos.m_122269_()).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
            };
            BiConsumer<Vector3f, Float> nd = (pos, renderAlpha) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_(), pos.m_122269_()).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_(), pos.m_122269_()).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            };
            BiConsumer<Vector3f, Float> su = (pos, renderAlpha) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_() + 1.0f, pos.m_122269_() + 1.0f).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_() + 1.0f, pos.m_122269_() + 1.0f).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            };
            BiConsumer<Vector3f, Float> sd = (pos, renderAlpha) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_(), pos.m_122269_() + 1.0f).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_(), pos.m_122269_() + 1.0f).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            };
            BiConsumer<Vector3f, Float> eu = (pos, renderAlpha) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_() + 1.0f, pos.m_122269_()).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_() + 1.0f, pos.m_122269_() + 1.0f).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            };
            BiConsumer<Vector3f, Float> ed = (pos, renderAlpha) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_(), pos.m_122269_()).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_(), pos.m_122269_() + 1.0f).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
            };
            BiConsumer<Vector3f, Float> wu = (pos, renderAlpha) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_() + 1.0f, pos.m_122269_()).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_() + 1.0f, pos.m_122269_() + 1.0f).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            };
            BiConsumer<Vector3f, Float> wd = (pos, renderAlpha) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_(), pos.m_122269_()).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_(), pos.m_122269_() + 1.0f).m_85950_(1.0f, 0.7f, 0.6f, renderAlpha.floatValue()).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            };
            LevelChunk workingChunk = (LevelChunk)level.m_46865_(new BlockPos(0, 0, 0));
            for (Map.Entry<BlockPos, Set<Pair<BlockPos, ArrayList<Direction>>>> entry : HEARTH_LOCATIONS.entrySet()) {
                if (HearthPathManagement.DISABLED_HEARTHS.contains(Pair.of((Object)entry.getKey(), (Object)level.m_46472_().m_135782_().toString()))) continue;
                Set<Pair<BlockPos, ArrayList<Direction>>> points = entry.getValue();
                for (Pair<BlockPos, ArrayList<Direction>> pair : points) {
                    float z;
                    float y;
                    BlockPos pos2 = (BlockPos)pair.getFirst();
                    ArrayList directions = (ArrayList)pair.getSecond();
                    float x = pos2.m_123341_();
                    float renderAlpha2 = CSMath.blend(0.2f, 0.0f, (float)CSMath.getDistance((Entity)player, x + 0.5f, (y = (float)pos2.m_123342_()) + 0.5f, (z = (float)pos2.m_123343_()) + 0.5f), 5.0f, 16.0f);
                    if (!(renderAlpha2 > 0.01f) || !frustum.m_113029_(new AABB(pos2))) continue;
                    ChunkPos chunkPos = new ChunkPos(pos2);
                    if (!workingChunk.m_7697_().equals((Object)chunkPos)) {
                        workingChunk = (LevelChunk)level.m_7726_().m_7587_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62326_, false);
                    }
                    if (WorldHelper.getBlockState((ChunkAccess)workingChunk, pos2).m_60808_((BlockGetter)level, pos2).equals(Shapes.m_83144_())) {
                        LevelRenderer.m_109608_((PoseStack)ps, (VertexConsumer)vertexes, (double)x, (double)y, (double)z, (double)(x + 1.0f), (double)(y + 1.0f), (double)(z + 1.0f), (float)1.0f, (float)0.7f, (float)0.6f, (float)renderAlpha2);
                        continue;
                    }
                    if (directions.size() == 6) continue;
                    HashSet lines = Sets.newHashSet((Object[])new BiConsumer[]{nw, ne, sw, se, nu, nd, su, sd, eu, ed, wu, wd});
                    if (directions.contains(Direction.DOWN)) {
                        Arrays.asList(nd, sd, ed, wd).forEach(lines::remove);
                    }
                    if (directions.contains(Direction.UP)) {
                        Arrays.asList(nu, su, eu, wu).forEach(lines::remove);
                    }
                    if (directions.contains(Direction.NORTH)) {
                        Arrays.asList(nw, ne, nu, nd).forEach(lines::remove);
                    }
                    if (directions.contains(Direction.SOUTH)) {
                        Arrays.asList(sw, se, su, sd).forEach(lines::remove);
                    }
                    if (directions.contains(Direction.WEST)) {
                        Arrays.asList(nw, sw, wu, wd).forEach(lines::remove);
                    }
                    if (directions.contains(Direction.EAST)) {
                        Arrays.asList(ne, se, eu, ed).forEach(lines::remove);
                    }
                    lines.forEach(line -> line.accept(new Vector3f(x, y, z), Float.valueOf(renderAlpha2)));
                }
            }
            RenderSystem.m_69461_();
            ps.m_85849_();
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91073_.m_46467_() % 20L == 0L && Minecraft.m_91087_().f_91066_.f_92063_ && ClientSettingsConfig.getInstance().hearthDebug()) {
            HEARTH_LOCATIONS.clear();
            for (Map.Entry<BlockPos, Integer> entry : HearthPathManagement.HEARTH_POSITIONS.entrySet()) {
                BlockPos pos = entry.getKey();
                BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(pos);
                if (!(blockEntity instanceof HearthBlockEntity)) continue;
                HearthBlockEntity hearth = (HearthBlockEntity)blockEntity;
                Set<BlockPos> paths = hearth.getPaths();
                HEARTH_LOCATIONS.put(pos, paths.stream().map(bp -> {
                    ArrayList<Direction> dirs = new ArrayList<Direction>();
                    for (Direction dir : Direction.values()) {
                        if (!paths.contains(bp.m_142300_(dir))) continue;
                        dirs.add(dir);
                    }
                    return Pair.of((Object)bp, dirs);
                }).collect(Collectors.toSet()));
            }
        }
    }
}

