/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import dev.momostudios.coldsweat.common.container.HearthContainer;
import dev.momostudios.coldsweat.common.event.HearthPathManagement;
import dev.momostudios.coldsweat.core.network.ColdSweatPacketHandler;
import dev.momostudios.coldsweat.core.network.message.DisableHearthParticlesMessage;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class HearthScreen
extends AbstractContainerScreen<HearthContainer> {
    private static final ResourceLocation HEARTH_GUI = new ResourceLocation("cold_sweat", "textures/gui/screen/hearth_gui.png");
    Pair<BlockPos, String> levelPos;
    boolean hideParticles;
    boolean hideParticlesOld;

    public HearthScreen(HearthContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, (Component)new TranslatableComponent("container.cold_sweat.hearth"));
        this.levelPos = Pair.of((Object)((HearthContainer)this.f_97732_).te.m_58899_(), (Object)((HearthContainer)this.f_97732_).te.m_58904_().m_46472_().m_135782_().toString());
        this.hideParticlesOld = this.hideParticles = HearthPathManagement.DISABLED_HEARTHS.contains(this.levelPos);
        this.f_97735_ = 0;
        this.f_97736_ = 0;
        this.f_97726_ = 176;
        this.f_97727_ = 166;
    }

    public void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 82, this.f_97736_ + 68, 12, 12, 176 + (!this.hideParticles ? 0 : 12), 36, 12, HEARTH_GUI, button -> {
            boolean bl = this.hideParticles = !this.hideParticles;
            if (this.hideParticles) {
                HearthPathManagement.DISABLED_HEARTHS.add(this.levelPos);
                if (HearthPathManagement.DISABLED_HEARTHS.size() > 20) {
                    HearthPathManagement.DISABLED_HEARTHS.remove(HearthPathManagement.DISABLED_HEARTHS.stream().findFirst().get());
                }
            } else {
                HearthPathManagement.DISABLED_HEARTHS.remove(this.levelPos);
            }
            Field imageX = ObfuscationReflectionHelper.findField(ImageButton.class, (String)"f_94224_");
            imageX.setAccessible(true);
            try {
                imageX.set(button, 176 + (!this.hideParticles ? 0 : 12));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }){

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (this.f_93623_ && this.f_93624_ && this.m_7972_(button) && this.m_93680_(mouseX, mouseY)) {
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12444_, (float)(!HearthScreen.this.hideParticles ? 1.5f : 1.9f), (float)0.75f));
                    this.m_5716_(mouseX, mouseY);
                    return true;
                }
                return false;
            }

            public void m_7428_(PoseStack poseStack, int mouseX, int mouseY) {
                HearthScreen.this.renderComponentTooltip(poseStack, List.of(new TranslatableComponent("cold_sweat.screen.hearth.show_particles")), mouseX, mouseY, HearthScreen.this.f_96547_);
            }
        });
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)HEARTH_GUI);
        int x = (this.f_96543_ - this.getXSize()) / 2;
        int y = (this.f_96544_ - this.getYSize()) / 2;
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        int hotFuel = (int)((double)((HearthContainer)this.f_97732_).getHotFuel() / 27.7);
        int coldFuel = (int)((double)((HearthContainer)this.f_97732_).getColdFuel() / 27.7);
        HearthScreen.m_93133_((PoseStack)poseStack, (int)(this.f_97735_ + 61), (int)(this.f_97736_ + 66 - hotFuel), (float)176.0f, (float)(36 - hotFuel), (int)12, (int)hotFuel, (int)256, (int)256);
        HearthScreen.m_93133_((PoseStack)poseStack, (int)(this.f_97735_ + 103), (int)(this.f_97736_ + 66 - coldFuel), (float)188.0f, (float)(36 - coldFuel), (int)12, (int)coldFuel, (int)256, (int)256);
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.f_96541_.f_91074_ != null && this.hideParticlesOld != this.hideParticles) {
            ColdSweatPacketHandler.INSTANCE.sendToServer((Object)new DisableHearthParticlesMessage((Player)Minecraft.m_91087_().f_91074_, HearthPathManagement.serializeDisabledHearths()));
        }
    }
}

