/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.client.gui.config;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.momostudios.coldsweat.client.gui.config.ConfigButton;
import dev.momostudios.coldsweat.client.gui.config.ConfigImage;
import dev.momostudios.coldsweat.client.gui.config.ConfigLabel;
import dev.momostudios.coldsweat.client.gui.config.ConfigScreen;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import dev.momostudios.coldsweat.util.math.CSMath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public abstract class AbstractConfigPage
extends Screen {
    static int MOUSE_STILL_TIMER = 0;
    static int TOOLTIP_DELAY = 5;
    private final Screen parentScreen;
    private final ConfigSettings configSettings;
    public Map<String, List<GuiEventListener>> widgetBatches = new HashMap<String, List<GuiEventListener>>();
    public Map<String, List<FormattedText>> tooltips = new HashMap<String, List<FormattedText>>();
    protected int rightSideLength = 0;
    protected int leftSideLength = 0;
    private static final int TITLE_HEIGHT = 16;
    private static final int BOTTOM_BUTTON_HEIGHT_OFFSET = 26;
    private static final int BOTTOM_BUTTON_WIDTH = 150;
    public static Minecraft mc = Minecraft.m_91087_();
    static ResourceLocation TEXTURE = new ResourceLocation("cold_sweat:textures/gui/screen/config_gui.png");
    ImageButton nextNavButton;
    ImageButton prevNavButton;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        ++MOUSE_STILL_TIMER;
    }

    public void m_94757_(double mouseX, double mouseY) {
        MOUSE_STILL_TIMER = 0;
        super.m_94757_(mouseX, mouseY);
    }

    public abstract BaseComponent sectionOneTitle();

    @Nullable
    public abstract BaseComponent sectionTwoTitle();

    public AbstractConfigPage(Screen parentScreen, ConfigSettings configSettings) {
        super((Component)new TranslatableComponent("cold_sweat.config.title"));
        this.parentScreen = parentScreen;
        this.configSettings = configSettings;
    }

    public int index() {
        return 0;
    }

    protected void addEmptySpace(Side side, double units) {
        if (side == Side.LEFT) {
            this.leftSideLength = (int)((double)this.leftSideLength + 25.0 * units);
        } else {
            this.rightSideLength = (int)((double)this.rightSideLength + 25.0 * units);
        }
    }

    protected void addLabel(String id, Side side, String text, int color) {
        int labelX = side == Side.LEFT ? this.f_96543_ / 2 - 185 : this.f_96543_ / 2 + 51;
        int labelY = this.f_96544_ / 4 + (side == Side.LEFT ? this.leftSideLength : this.rightSideLength);
        ConfigLabel label = new ConfigLabel(id, text, labelX, labelY, color);
        this.addWidgetBatch(id, List.of(label));
        if (side == Side.LEFT) {
            Objects.requireNonNull(this.f_96547_);
            this.leftSideLength += 9 + 4;
        } else {
            Objects.requireNonNull(this.f_96547_);
            this.rightSideLength += 9 + 4;
        }
    }

    protected void addLabel(String id, Side side, String text) {
        this.addLabel(id, side, text, 0xFFFFFF);
    }

    protected void addButton(String id, Side side, Supplier<String> dynamicLabel, Consumer<Button> onClick, boolean requireOP, final boolean setsCustomDifficulty, boolean clientside, String ... tooltip) {
        String label = dynamicLabel.get();
        boolean shouldBeActive = !requireOP || AbstractConfigPage.mc.f_91074_ == null || AbstractConfigPage.mc.f_91074_.m_20310_(2);
        int buttonX = this.f_96543_ / 2;
        int xOffset = side == Side.LEFT ? -179 : 56;
        int buttonY = this.f_96544_ / 4 - 8 + (side == Side.LEFT ? this.leftSideLength : this.rightSideLength);
        int buttonWidth = 152 + Math.max(0, this.f_96547_.m_92895_(label) - 140);
        ConfigButton button = new ConfigButton(buttonX + xOffset, buttonY, buttonWidth, 20, (BaseComponent)new TextComponent(label), button1 -> {
            onClick.accept(button1);
            button1.m_93666_((Component)new TextComponent((String)dynamicLabel.get()));
        }){

            @Override
            public boolean setsCustomDifficulty() {
                return setsCustomDifficulty;
            }
        };
        button.f_93623_ = shouldBeActive;
        if (clientside) {
            this.m_169394_(new ConfigImage(TEXTURE, this.f_96543_ / 2 + xOffset - 18, buttonY + 3, 16, 15, 0, 144));
        }
        this.addWidgetBatch(id, List.of(button));
        if (side == Side.LEFT) {
            this.leftSideLength += 25;
        } else {
            this.rightSideLength += 25;
        }
        this.setTooltip(id, tooltip);
    }

    protected void addDecimalInput(String id, Side side, Component label, final Consumer<Double> onValueWrite, Consumer<EditBox> onInit, boolean requireOP, final boolean setsCustomDifficulty, boolean clientside, String ... tooltip) {
        boolean shouldBeActive = !requireOP || AbstractConfigPage.mc.f_91074_ == null || AbstractConfigPage.mc.f_91074_.m_20310_(2);
        int xOffset = side == Side.LEFT ? -82 : 151;
        int yOffset = (side == Side.LEFT ? this.leftSideLength : this.rightSideLength) - 2;
        int labelOffset = this.f_96547_.m_92895_(label.getString()) > 90 ? this.f_96547_.m_92895_(label.getString()) - 84 : 0;
        EditBox textBox = new EditBox(this.f_96547_, this.f_96543_ / 2 + xOffset + labelOffset, this.f_96544_ / 4 - 6 + yOffset, 51, 22, (Component)new TextComponent("")){

            public void m_94164_(String text) {
                super.m_94164_(text);
                CSMath.tryCatch(() -> {
                    if (setsCustomDifficulty) {
                        AbstractConfigPage.this.configSettings.difficulty = 4;
                    }
                    onValueWrite.accept(Double.parseDouble(this.m_94155_()));
                });
            }

            public void m_94176_(int i) {
                super.m_94176_(i);
                CSMath.tryCatch(() -> {
                    if (setsCustomDifficulty) {
                        AbstractConfigPage.this.configSettings.difficulty = 4;
                    }
                    onValueWrite.accept(Double.parseDouble(this.m_94155_()));
                });
            }

            public void m_94180_(int i) {
                super.m_94180_(i);
                CSMath.tryCatch(() -> {
                    if (setsCustomDifficulty) {
                        AbstractConfigPage.this.configSettings.difficulty = 4;
                    }
                    onValueWrite.accept(Double.parseDouble(this.m_94155_()));
                });
            }
        };
        textBox.m_94186_(shouldBeActive);
        onInit.accept(textBox);
        textBox.m_94144_(ConfigScreen.TWO_PLACES.format(Double.parseDouble(textBox.m_94155_())));
        ConfigLabel configLabel = new ConfigLabel(id, label.getString(), this.f_96543_ / 2 + xOffset - 95, this.f_96544_ / 4 + yOffset, shouldBeActive ? 0xFFFFFF : 0x808080);
        if (clientside) {
            this.m_169394_(new ConfigImage(TEXTURE, this.f_96543_ / 2 + xOffset - 115, this.f_96544_ / 4 - 4 + yOffset, 16, 15, 0, 144));
        }
        this.setTooltip(id, tooltip);
        this.addWidgetBatch(id, List.of(textBox, configLabel));
        if (side == Side.LEFT) {
            this.leftSideLength = (int)((double)this.leftSideLength + 30.0);
        } else {
            this.rightSideLength = (int)((double)this.rightSideLength + 30.0);
        }
    }

    protected void addDirectionPanel(String id, Side side, Component label, Consumer<Integer> leftRightPressed, Consumer<Integer> upDownPressed, Runnable reset, boolean requireOP, boolean setsCustomDifficulty, boolean clientside, String ... tooltip) {
        int xOffset = side == Side.LEFT ? -81 : 152;
        int yOffset = side == Side.LEFT ? this.leftSideLength : this.rightSideLength;
        boolean shouldBeActive = !requireOP || AbstractConfigPage.mc.f_91074_ == null || AbstractConfigPage.mc.f_91074_.m_20310_(2);
        int labelOffset = this.f_96547_.m_92895_(label.getString()) > 84 ? this.f_96547_.m_92895_(label.getString()) - 84 : 0;
        ImageButton leftButton = new ImageButton(this.f_96543_ / 2 + xOffset + labelOffset, this.f_96544_ / 4 - 8 + yOffset, 14, 20, 0, 0, 20, TEXTURE, button -> {
            leftRightPressed.accept(-1);
            if (setsCustomDifficulty) {
                this.configSettings.difficulty = 4;
            }
        });
        leftButton.f_93623_ = shouldBeActive;
        ImageButton upButton = new ImageButton(this.f_96543_ / 2 + xOffset + 14 + labelOffset, this.f_96544_ / 4 - 8 + yOffset, 20, 10, 14, 0, 20, TEXTURE, button -> {
            upDownPressed.accept(-1);
            if (setsCustomDifficulty) {
                this.configSettings.difficulty = 4;
            }
        });
        upButton.f_93623_ = shouldBeActive;
        ImageButton downButton = new ImageButton(this.f_96543_ / 2 + xOffset + 14 + labelOffset, this.f_96544_ / 4 + 2 + yOffset, 20, 10, 14, 10, 20, TEXTURE, button -> {
            upDownPressed.accept(1);
            if (setsCustomDifficulty) {
                this.configSettings.difficulty = 4;
            }
        });
        downButton.f_93623_ = shouldBeActive;
        ImageButton rightButton = new ImageButton(this.f_96543_ / 2 + xOffset + 34 + labelOffset, this.f_96544_ / 4 - 8 + yOffset, 14, 20, 34, 0, 20, TEXTURE, button -> {
            leftRightPressed.accept(1);
            if (setsCustomDifficulty) {
                this.configSettings.difficulty = 4;
            }
        });
        rightButton.f_93623_ = shouldBeActive;
        ImageButton resetButton = new ImageButton(this.f_96543_ / 2 + xOffset + 52 + labelOffset, this.f_96544_ / 4 - 8 + yOffset, 20, 20, 48, 0, 20, TEXTURE, button -> {
            reset.run();
            if (setsCustomDifficulty) {
                this.configSettings.difficulty = 4;
            }
        });
        resetButton.f_93623_ = shouldBeActive;
        ConfigLabel configLabel = new ConfigLabel(id, label.getString(), this.f_96543_ / 2 + xOffset - 95, this.f_96544_ / 4 + yOffset, shouldBeActive ? 0xFFFFFF : 0x808080);
        if (clientside) {
            this.m_169394_(new ConfigImage(TEXTURE, this.f_96543_ / 2 + xOffset - 114, this.f_96544_ / 4 - 8 + yOffset + 5, 16, 15, 0, 144));
        }
        this.setTooltip(id, tooltip);
        this.addWidgetBatch(id, List.of(upButton, downButton, leftButton, rightButton, resetButton, configLabel));
        if (side == Side.LEFT) {
            this.leftSideLength = (int)((double)this.leftSideLength + 37.5);
        } else {
            this.rightSideLength = (int)((double)this.rightSideLength + 37.5);
        }
    }

    protected void m_7856_() {
        this.leftSideLength = 0;
        this.rightSideLength = 0;
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 75, this.f_96544_ - 26, 150, 20, (Component)new TranslatableComponent("gui.done"), button -> this.close()));
        this.nextNavButton = new ImageButton(this.f_96543_ - 32, 12, 20, 20, 0, 88, 20, TEXTURE, button -> mc.m_91152_(ConfigScreen.getPage(this.index() + 1, this.parentScreen, this.configSettings)));
        if (this.index() < ConfigScreen.LAST_PAGE) {
            this.m_142416_((GuiEventListener)this.nextNavButton);
        }
        this.prevNavButton = new ImageButton(this.f_96543_ - 76, 12, 20, 20, 20, 88, 20, TEXTURE, button -> mc.m_91152_(ConfigScreen.getPage(this.index() - 1, this.parentScreen, this.configSettings)));
        if (this.index() > ConfigScreen.FIRST_PAGE) {
            this.m_142416_((GuiEventListener)this.prevNavButton);
        }
    }

    public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        AbstractConfigPage.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.f_96539_.getString(), (int)(this.f_96543_ / 2), (int)16, (int)0xFFFFFF);
        AbstractConfigPage.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)new TextComponent(this.index() + 1 + "/" + (ConfigScreen.LAST_PAGE + 1)), (int)(this.f_96543_ - 53), (int)18, (int)0xFFFFFF);
        AbstractConfigPage.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.sectionOneTitle(), (int)(this.f_96543_ / 2 - 204), (int)(this.f_96544_ / 4 - 28), (int)0xFFFFFF);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(poseStack, this.f_96543_ / 2 - 202, this.f_96544_ / 4 - 16, 255, 0, 1, 154);
        if (this.sectionTwoTitle() != null) {
            AbstractConfigPage.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.sectionTwoTitle(), (int)(this.f_96543_ / 2 + 32), (int)(this.f_96544_ / 4 - 28), (int)0xFFFFFF);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            this.m_93228_(poseStack, this.f_96543_ / 2 + 34, this.f_96544_ / 4 - 16, 255, 0, 1, 154);
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        if (MOUSE_STILL_TIMER >= TOOLTIP_DELAY) {
            for (Map.Entry<String, List<GuiEventListener>> entry : this.widgetBatches.entrySet()) {
                String id = entry.getKey();
                List<GuiEventListener> widgets = entry.getValue();
                if (!widgets.stream().anyMatch(widget -> widget.m_5953_((double)mouseX, (double)mouseY))) continue;
                List<FormattedText> tooltipList = this.tooltips.get(id);
                if (tooltipList == null || tooltipList.isEmpty()) break;
                List tooltip = this.tooltips.get(id).stream().map(text -> new TextComponent(text.getString())).collect(Collectors.toList());
                this.m_96597_(poseStack, tooltip, mouseX, mouseY);
                break;
            }
        }
    }

    public void m_96624_() {
        super.m_96624_();
    }

    public boolean m_7043_() {
        return true;
    }

    public void close() {
        this.m_7379_();
        Minecraft.m_91087_().m_91152_(this.parentScreen);
    }

    protected void addWidgetBatch(String id, List<GuiEventListener> elements) {
        for (GuiEventListener element : elements) {
            if (!(element instanceof Widget) || !(element instanceof NarratableEntry)) continue;
            NarratableEntry widget = (NarratableEntry)element;
            this.m_142416_((GuiEventListener)((NarratableEntry)((Widget)widget)));
        }
        this.widgetBatches.put(id, elements);
    }

    public List<GuiEventListener> getWidgetBatch(String id) {
        return this.widgetBatches.get(id);
    }

    protected void setTooltip(String id, String[] tooltip) {
        ArrayList tooltipList = new ArrayList();
        for (String string : tooltip) {
            tooltipList.addAll(this.f_96547_.m_92865_().m_92432_(string, 300, Style.f_131099_));
        }
        this.tooltips.put(id, tooltipList);
    }

    public static enum Side {
        LEFT,
        RIGHT;

    }
}

