/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.client.gui.config;

import dev.momostudios.coldsweat.client.gui.config.AbstractConfigPage;
import dev.momostudios.coldsweat.client.gui.config.pages.ConfigPageDifficulty;
import dev.momostudios.coldsweat.client.gui.config.pages.ConfigPageOne;
import dev.momostudios.coldsweat.client.gui.config.pages.ConfigPageTwo;
import dev.momostudios.coldsweat.config.ColdSweatConfig;
import dev.momostudios.coldsweat.core.network.ColdSweatPacketHandler;
import dev.momostudios.coldsweat.core.network.message.ClientConfigSendMessage;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ConfigScreen {
    public static final int TITLE_HEIGHT = 16;
    public static final int BOTTOM_BUTTON_HEIGHT_OFFSET = 26;
    public static final int OPTION_SIZE = 25;
    public static final int BOTTOM_BUTTON_WIDTH = 150;
    public static Minecraft MC = Minecraft.m_91087_();
    public static DecimalFormat TWO_PLACES = new DecimalFormat("#.##");
    public static boolean IS_MOUSE_DOWN = false;
    public static int MOUSE_X = 0;
    public static int MOUSE_Y = 0;
    static List<Class<? extends AbstractConfigPage>> PAGES = Arrays.asList(ConfigPageOne.class, ConfigPageTwo.class);
    public static int FIRST_PAGE = 0;
    public static int LAST_PAGE = PAGES.size() - 1;

    public static Screen getPage(int index, Screen parentScreen, ConfigSettings configSettings) {
        index = Math.max(FIRST_PAGE, Math.min(LAST_PAGE, index));
        try {
            return PAGES.get(index).getConstructor(Screen.class, ConfigSettings.class).newInstance(parentScreen, configSettings);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void saveConfig(ConfigSettings configSettings) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            if (Minecraft.m_91087_().f_91074_.m_8088_() >= 2) {
                if (!MC.m_91090_()) {
                    ColdSweatPacketHandler.INSTANCE.sendToServer((Object)new ClientConfigSendMessage(configSettings));
                } else {
                    ColdSweatConfig.getInstance().writeValues(configSettings);
                }
            }
        } else {
            ColdSweatConfig.getInstance().writeValues(configSettings);
        }
        ConfigSettings.setInstance(configSettings);
    }

    @SubscribeEvent
    public static void onClicked(ScreenEvent.MouseClickedEvent event) {
        if (event.getButton() == 0 && Minecraft.m_91087_().f_91080_ instanceof ConfigPageDifficulty) {
            IS_MOUSE_DOWN = true;
        }
    }

    @SubscribeEvent
    public static void onReleased(ScreenEvent.MouseReleasedEvent event) {
        if (event.getButton() == 0 && Minecraft.m_91087_().f_91080_ instanceof ConfigPageDifficulty) {
            IS_MOUSE_DOWN = false;
        }
    }

    public static String difficultyName(int difficulty) {
        return difficulty == 0 ? new TranslatableComponent("cold_sweat.config.difficulty.super_easy.name").getString() : (difficulty == 1 ? new TranslatableComponent("cold_sweat.config.difficulty.easy.name").getString() : (difficulty == 2 ? new TranslatableComponent("cold_sweat.config.difficulty.normal.name").getString() : (difficulty == 3 ? new TranslatableComponent("cold_sweat.config.difficulty.hard.name").getString() : (difficulty == 4 ? new TranslatableComponent("cold_sweat.config.difficulty.custom.name").getString() : ""))));
    }

    public static int difficultyColor(int difficulty) {
        return difficulty == 0 ? 0xFFFFFF : (difficulty == 1 ? 16768882 : (difficulty == 2 ? 16755024 : (difficulty == 3 ? 16731202 : (difficulty == 4 ? 10631158 : 0xFFFFFF))));
    }

    public static int textOptionColor() {
        return Minecraft.m_91087_().f_91074_ == null || Minecraft.m_91087_().f_91074_.m_8088_() > 2 ? 0xFFFFFF : 0x808080;
    }
}

