/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.client.gui.config.pages;

import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.client.gui.Overlays;
import dev.momostudios.coldsweat.client.gui.config.AbstractConfigPage;
import dev.momostudios.coldsweat.client.gui.config.ConfigScreen;
import dev.momostudios.coldsweat.client.gui.config.pages.ConfigPageDifficulty;
import dev.momostudios.coldsweat.config.ClientSettingsConfig;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import dev.momostudios.coldsweat.util.math.CSMath;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class ConfigPageOne
extends AbstractConfigPage {
    Screen parentScreen;
    ConfigSettings configSettings;
    private final String ON;
    private final String OFF;

    public ConfigPageOne(Screen parentScreen, ConfigSettings configSettings) {
        super(parentScreen, configSettings);
        if (parentScreen == null) {
            parentScreen = Minecraft.m_91087_().f_91080_;
        }
        this.parentScreen = parentScreen;
        this.configSettings = configSettings;
        this.ON = new TranslatableComponent("options.on").getString();
        this.OFF = new TranslatableComponent("options.off").getString();
    }

    @Override
    public int index() {
        return 0;
    }

    @Override
    public BaseComponent sectionOneTitle() {
        return new TranslatableComponent("cold_sweat.config.section.temperature_details");
    }

    @Override
    public BaseComponent sectionTwoTitle() {
        return new TranslatableComponent("cold_sweat.config.section.difficulty.name");
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        ClientSettingsConfig clientConfig = ClientSettingsConfig.getInstance();
        Supplier<Temperature.Units> properUnits = () -> clientConfig.celsius() ? Temperature.Units.C : Temperature.Units.F;
        this.addButton("units", AbstractConfigPage.Side.LEFT, () -> new TranslatableComponent("cold_sweat.config.units.name").getString() + ": " + (clientConfig.celsius() ? new TranslatableComponent("cold_sweat.config.celsius.name").getString() : new TranslatableComponent("cold_sweat.config.fahrenheit.name").getString()), button -> {
            clientConfig.setCelsius(!clientConfig.celsius());
            Overlays.WORLD_TEMP = CSMath.convertUnits(Overlays.PLAYER_CAP.getTemp(Temperature.Type.WORLD), Temperature.Units.MC, (Temperature.Units)((Object)((Object)properUnits.get())), true);
            button.m_93666_((Component)new TextComponent(new TranslatableComponent("cold_sweat.config.units.name").getString() + ": " + (clientConfig.celsius() ? new TranslatableComponent("cold_sweat.config.celsius.name").getString() : new TranslatableComponent("cold_sweat.config.fahrenheit.name").getString())));
            ((EditBox)((List)this.widgetBatches.get("max_temp")).get(0)).m_94144_(String.valueOf(ConfigScreen.TWO_PLACES.format(CSMath.convertUnits(this.configSettings.maxTemp, Temperature.Units.MC, (Temperature.Units)((Object)((Object)properUnits.get())), true))));
            ((EditBox)((List)this.widgetBatches.get("min_temp")).get(0)).m_94144_(String.valueOf(ConfigScreen.TWO_PLACES.format(CSMath.convertUnits(this.configSettings.minTemp, Temperature.Units.MC, (Temperature.Units)((Object)((Object)properUnits.get())), true))));
        }, false, false, true, new TranslatableComponent("cold_sweat.config.units.desc").getString());
        this.addDecimalInput("temp_offset", AbstractConfigPage.Side.LEFT, (Component)new TranslatableComponent("cold_sweat.config.temp_offset.name"), value -> clientConfig.setTempOffset(value.intValue()), input -> input.m_94144_(String.valueOf(clientConfig.tempOffset())), false, false, true, new TranslatableComponent("cold_sweat.config.temp_offset.desc_1").getString(), "\u00a77" + new TranslatableComponent("cold_sweat.config.temp_offset.desc_2").getString() + "\u00a7r");
        this.addDecimalInput("max_temp", AbstractConfigPage.Side.LEFT, (Component)new TranslatableComponent("cold_sweat.config.max_temperature.name"), value -> {
            this.configSettings.maxTemp = CSMath.convertUnits(value, (Temperature.Units)((Object)((Object)properUnits.get())), Temperature.Units.MC, true);
        }, input -> input.m_94144_(String.valueOf(CSMath.convertUnits(this.configSettings.maxTemp, Temperature.Units.MC, (Temperature.Units)((Object)((Object)properUnits.get())), true))), false, false, false, new TranslatableComponent("cold_sweat.config.max_temperature.desc").getString());
        this.addDecimalInput("min_temp", AbstractConfigPage.Side.LEFT, (Component)new TranslatableComponent("cold_sweat.config.min_temperature.name"), value -> {
            this.configSettings.minTemp = CSMath.convertUnits(value, (Temperature.Units)((Object)((Object)properUnits.get())), Temperature.Units.MC, true);
        }, input -> input.m_94144_(String.valueOf(CSMath.convertUnits(this.configSettings.minTemp, Temperature.Units.MC, (Temperature.Units)((Object)((Object)properUnits.get())), true))), false, false, false, new TranslatableComponent("cold_sweat.config.min_temperature.desc").getString());
        this.addDecimalInput("rate", AbstractConfigPage.Side.LEFT, (Component)new TranslatableComponent("cold_sweat.config.temperature_rate.name"), value -> {
            this.configSettings.rate = value;
        }, input -> input.m_94144_(String.valueOf(this.configSettings.rate)), false, false, false, new TranslatableComponent("cold_sweat.config.temperature_rate.desc").getString());
        this.addButton("difficulty", AbstractConfigPage.Side.RIGHT, () -> new TranslatableComponent("cold_sweat.config.difficulty.name").getString() + " (" + ConfigScreen.difficultyName(this.configSettings.difficulty) + ")...", button -> mc.m_91152_((Screen)new ConfigPageDifficulty(this, this.configSettings)), true, false, false, new TranslatableComponent("cold_sweat.config.difficulty.desc").getString());
        this.addEmptySpace(AbstractConfigPage.Side.RIGHT, 1.0);
        this.addButton("ice_resistance", AbstractConfigPage.Side.RIGHT, () -> new TranslatableComponent("cold_sweat.config.ice_resistance.name").getString() + ": " + (this.configSettings.iceRes ? this.ON : this.OFF), button -> {
            this.configSettings.iceRes = !this.configSettings.iceRes;
        }, true, true, false, new TranslatableComponent("cold_sweat.config.ice_resistance.desc").getString());
        this.addButton("fire_resistance", AbstractConfigPage.Side.RIGHT, () -> new TranslatableComponent("cold_sweat.config.fire_resistance.name").getString() + ": " + (this.configSettings.fireRes ? this.ON : this.OFF), button -> {
            this.configSettings.fireRes = !this.configSettings.fireRes;
        }, true, true, false, new TranslatableComponent("cold_sweat.config.fire_resistance.desc").getString());
        this.addButton("require_thermometer", AbstractConfigPage.Side.RIGHT, () -> new TranslatableComponent("cold_sweat.config.require_thermometer.name").getString() + ": " + (this.configSettings.requireThermometer ? this.ON : this.OFF), button -> {
            this.configSettings.requireThermometer = !this.configSettings.requireThermometer;
        }, true, true, false, new TranslatableComponent("cold_sweat.config.require_thermometer.desc").getString());
        this.addButton("damage_scaling", AbstractConfigPage.Side.RIGHT, () -> new TranslatableComponent("cold_sweat.config.damage_scaling.name").getString() + ": " + (this.configSettings.damageScaling ? this.ON : this.OFF), button -> {
            this.configSettings.damageScaling = !this.configSettings.damageScaling;
        }, true, true, false, new TranslatableComponent("cold_sweat.config.damage_scaling.desc").getString());
    }

    public void m_7379_() {
        ConfigScreen.saveConfig(this.configSettings);
        super.m_7379_();
    }
}

