/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.common.blockentity;

import dev.momostudios.coldsweat.common.block.BoilerBlock;
import dev.momostudios.coldsweat.common.container.BoilerContainer;
import dev.momostudios.coldsweat.core.network.ColdSweatPacketHandler;
import dev.momostudios.coldsweat.core.network.message.BlockDataUpdateMessage;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import dev.momostudios.coldsweat.util.registries.ModBlockEntities;
import dev.momostudios.coldsweat.util.registries.ModItems;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.PacketDistributor;

public class BoilerBlockEntity
extends BaseContainerBlockEntity
implements MenuProvider {
    public static int SLOTS = 10;
    public static int MAX_FUEL = 1000;
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)SLOTS, (Object)ItemStack.f_41583_);
    List<ServerPlayer> usingPlayers = new ArrayList<ServerPlayer>();
    public int ticksExisted;
    int fuel;

    public BoilerBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.BOILER, pos, state);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("fuel", this.getFuel());
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.setFuel(tag.m_128451_("fuel"));
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    private void sendUpdatePacket() {
        this.usingPlayers.removeIf(player -> {
            AbstractContainerMenu patt2949$temp = player.f_36096_;
            if (!(patt2949$temp instanceof BoilerContainer)) return true;
            BoilerContainer boilerContainer = (BoilerContainer)patt2949$temp;
            if (boilerContainer.te != this) return true;
            return false;
        });
        ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.NMLIST.with(() -> this.usingPlayers.stream().map(player -> player.f_8906_.f_9742_).toList()), (Object)new BlockDataUpdateMessage((BlockEntity)this));
    }

    protected Component m_6820_() {
        return new TranslatableComponent("container.cold_sweat.boiler");
    }

    public Component m_5446_() {
        return this.m_7770_() != null ? this.m_7770_() : this.m_6820_();
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T te) {
        if (te instanceof BoilerBlockEntity) {
            BoilerBlockEntity iceboxTE = (BoilerBlockEntity)te;
            iceboxTE.tick(level, state, pos);
        }
    }

    public void tick(Level level, BlockState state, BlockPos pos) {
        ItemStack fuelStack;
        int itemFuel;
        ++this.ticksExisted;
        if (this.getFuel() > 0) {
            if (!((Boolean)state.m_61143_((Property)BoilerBlock.LIT)).booleanValue()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BoilerBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
            }
            if (this.ticksExisted % 20 == 0) {
                boolean hasItemStacks = false;
                for (int i = 1; i < 10; ++i) {
                    ItemStack stack = this.m_8020_(i);
                    int itemTemp = stack.m_41784_().m_128451_("temperature");
                    if (stack.m_41720_() != ModItems.FILLED_WATERSKIN || itemTemp >= 50) continue;
                    hasItemStacks = true;
                    stack.m_41784_().m_128405_("temperature", itemTemp + 1);
                }
                if (hasItemStacks) {
                    this.setFuel(this.getFuel() - 1);
                }
            }
        } else if (((Boolean)state.m_61143_((Property)BoilerBlock.LIT)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BoilerBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
        if (this.ticksExisted % 10 == 0 && (itemFuel = this.getItemFuel(fuelStack = this.m_8020_(0))) != 0 && this.getFuel() < MAX_FUEL - itemFuel / 2) {
            if (fuelStack.hasContainerItem() && fuelStack.m_41613_() == 1) {
                this.m_6836_(0, fuelStack.getContainerItem());
                this.setFuel(this.getFuel() + itemFuel);
            } else {
                int consumeCount = Math.min((int)Math.floor((double)(MAX_FUEL - this.fuel) / (double)Math.abs(itemFuel)), fuelStack.m_41613_());
                fuelStack.m_41774_(consumeCount);
                this.setFuel(this.getFuel() + itemFuel * consumeCount);
            }
        }
    }

    public int getItemFuel(ItemStack item) {
        return ConfigSettings.BOILER_FUEL.get().getOrDefault(item.m_41720_(), 0.0).intValue();
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int amount) {
        this.fuel = Math.min(amount, MAX_FUEL);
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.sendUpdatePacket();
        }
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory playerInv) {
        Player player = playerInv.f_35978_;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.usingPlayers.add(serverPlayer);
        }
        return new BoilerContainer(id, playerInv, this);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.setFuel(tag.m_128451_("fuel"));
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128405_("fuel", this.getFuel());
    }

    public int m_6643_() {
        return SLOTS;
    }

    public boolean m_7983_() {
        return this.items.isEmpty();
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack m_7407_(int slot, int count) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.items, (int)slot, (int)count);
        if (!itemstack.m_41619_()) {
            this.m_6596_();
        }
        return itemstack;
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18969_(this.items, (int)slot, (int)((ItemStack)this.items.get(slot)).m_41613_());
    }

    public void m_6836_(int slot, ItemStack itemstack) {
        this.items.set(slot, (Object)itemstack);
    }

    public boolean m_6542_(Player player) {
        return player.m_20275_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.items.clear();
    }
}

