/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.common.capability;

import dev.momostudios.coldsweat.ColdSweat;
import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.api.temperature.modifier.TempModifier;
import dev.momostudios.coldsweat.api.util.TempHelper;
import dev.momostudios.coldsweat.common.capability.ITemperatureCap;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import dev.momostudios.coldsweat.util.entity.ModDamageSources;
import dev.momostudios.coldsweat.util.entity.NBTHelper;
import dev.momostudios.coldsweat.util.math.CSMath;
import dev.momostudios.coldsweat.util.registries.ModEffects;
import dev.momostudios.coldsweat.util.registries.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;

public class PlayerTempCap
implements ITemperatureCap {
    static Temperature.Type[] VALID_MODIFIER_TYPES = new Temperature.Type[]{Temperature.Type.CORE, Temperature.Type.BASE, Temperature.Type.RATE, Temperature.Type.MAX, Temperature.Type.MIN, Temperature.Type.WORLD};
    static Temperature.Type[] VALID_TEMPERATURE_TYPES = new Temperature.Type[]{Temperature.Type.CORE, Temperature.Type.BASE, Temperature.Type.MAX, Temperature.Type.MIN, Temperature.Type.WORLD};
    private double[] syncedValues = new double[5];
    double ticksSinceSync = 0.0;
    double worldTemp = 1.0;
    double coreTemp = 0.0;
    double baseTemp = 0.0;
    double maxOffset = 0.0;
    double minOffset = 0.0;
    public boolean showBodyTemp;
    public boolean showWorldTemp;
    List<TempModifier> worldModifiers = new ArrayList<TempModifier>();
    List<TempModifier> coreModifiers = new ArrayList<TempModifier>();
    List<TempModifier> baseModifiers = new ArrayList<TempModifier>();
    List<TempModifier> rateModifiers = new ArrayList<TempModifier>();
    List<TempModifier> maxModifiers = new ArrayList<TempModifier>();
    List<TempModifier> minModifiers = new ArrayList<TempModifier>();

    @Override
    public double getTemp(Temperature.Type type) {
        return switch (type) {
            case Temperature.Type.WORLD -> this.worldTemp;
            case Temperature.Type.CORE -> this.coreTemp;
            case Temperature.Type.BASE -> this.baseTemp;
            case Temperature.Type.BODY -> this.baseTemp + this.coreTemp;
            case Temperature.Type.MAX -> this.maxOffset;
            case Temperature.Type.MIN -> this.minOffset;
            default -> throw new IllegalArgumentException("Illegal type for PlayerTempCapability.getValue(): " + type);
        };
    }

    @Override
    public void setTemp(Temperature.Type type, double value) {
        switch (type) {
            case WORLD: {
                this.worldTemp = value;
                break;
            }
            case CORE: {
                this.coreTemp = value;
                break;
            }
            case BASE: {
                this.baseTemp = value;
                break;
            }
            case MAX: {
                this.maxOffset = value;
                break;
            }
            case MIN: {
                this.minOffset = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal type for PlayerTempCapability.setValue(): " + type);
            }
        }
    }

    @Override
    public List<TempModifier> getModifiers(Temperature.Type type) {
        return switch (type) {
            case Temperature.Type.WORLD -> this.worldModifiers;
            case Temperature.Type.CORE -> this.coreModifiers;
            case Temperature.Type.BASE -> this.baseModifiers;
            case Temperature.Type.RATE -> this.rateModifiers;
            case Temperature.Type.MAX -> this.maxModifiers;
            case Temperature.Type.MIN -> this.minModifiers;
            default -> throw new IllegalArgumentException("Illegal type for PlayerTempCapability.getModifiers(): " + type);
        };
    }

    @Override
    public boolean hasModifier(Temperature.Type type, Class<? extends TempModifier> mod) {
        return switch (type) {
            case Temperature.Type.WORLD -> this.worldModifiers.stream().anyMatch(mod::isInstance);
            case Temperature.Type.CORE -> this.coreModifiers.stream().anyMatch(mod::isInstance);
            case Temperature.Type.BASE -> this.baseModifiers.stream().anyMatch(mod::isInstance);
            case Temperature.Type.RATE -> this.rateModifiers.stream().anyMatch(mod::isInstance);
            case Temperature.Type.MAX -> this.maxModifiers.stream().anyMatch(mod::isInstance);
            case Temperature.Type.MIN -> this.minModifiers.stream().anyMatch(mod::isInstance);
            default -> throw new IllegalArgumentException("Illegal type for PlayerTempCapability.hasModifier(): " + type);
        };
    }

    @Override
    public void clearModifiers(Temperature.Type type) {
        switch (type) {
            case WORLD: {
                this.worldModifiers.clear();
                break;
            }
            case CORE: {
                this.coreModifiers.clear();
                break;
            }
            case BASE: {
                this.baseModifiers.clear();
                break;
            }
            case RATE: {
                this.rateModifiers.clear();
                break;
            }
            case MAX: {
                this.maxModifiers.clear();
                break;
            }
            case MIN: {
                this.minModifiers.clear();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal type for PlayerTempCapability.clearModifiers(): " + type);
            }
        }
    }

    @Override
    public void copy(ITemperatureCap cap) {
        this.worldModifiers = cap.getModifiers(Temperature.Type.WORLD);
        this.baseModifiers = cap.getModifiers(Temperature.Type.BASE);
        this.coreModifiers = cap.getModifiers(Temperature.Type.CORE);
        this.rateModifiers = cap.getModifiers(Temperature.Type.RATE);
        this.maxModifiers = cap.getModifiers(Temperature.Type.RATE);
        this.minModifiers = cap.getModifiers(Temperature.Type.RATE);
        this.worldTemp = cap.getTemp(Temperature.Type.WORLD);
        this.coreTemp = cap.getTemp(Temperature.Type.CORE);
        this.baseTemp = cap.getTemp(Temperature.Type.BASE);
        this.maxOffset = cap.getTemp(Temperature.Type.MAX);
        this.minOffset = cap.getTemp(Temperature.Type.MIN);
    }

    @Override
    public void tickDummy(Player player) {
        for (Temperature.Type type : VALID_MODIFIER_TYPES) {
            new Temperature().with(player, this.getModifiers(type));
        }
    }

    @Override
    public void tick(Player player) {
        ConfigSettings config = ConfigSettings.getInstance();
        double newWorldTemp = new Temperature().with(player, this.getModifiers(Temperature.Type.WORLD)).get();
        double newCoreTemp = new Temperature(this.coreTemp).with(player, this.getModifiers(Temperature.Type.CORE)).get();
        double newBaseTemp = new Temperature().with(player, this.getModifiers(Temperature.Type.BASE)).get();
        double newMaxOffset = new Temperature().with(player, this.getModifiers(Temperature.Type.MAX)).get();
        double newMinOffset = new Temperature().with(player, this.getModifiers(Temperature.Type.MIN)).get();
        double maxTemp = config.maxTemp + newMaxOffset;
        double minTemp = config.minTemp + newMinOffset;
        double tempRate = 7.0;
        int magnitude = CSMath.getSignForRange(newWorldTemp, minTemp, maxTemp);
        if (magnitude != 0 && !player.m_7500_() && !player.m_5833_()) {
            double difference = Math.abs(newWorldTemp - CSMath.clamp(newWorldTemp, minTemp, maxTemp));
            Temperature changeBy = new Temperature(Math.max(difference / tempRate * (double)((float)config.rate), (double)Math.abs((float)config.rate / 50.0f)) * (double)magnitude);
            newCoreTemp += changeBy.with(player, this.getModifiers(Temperature.Type.RATE)).get();
        }
        if (magnitude != CSMath.getSign(newCoreTemp)) {
            newCoreTemp += this.getBodyReturnRate(newWorldTemp, newCoreTemp > 0.0 ? maxTemp : minTemp, config.rate, newCoreTemp);
        }
        if (player.f_19797_ % 20 == 0) {
            this.showWorldTemp = !ConfigSettings.getInstance().requireThermometer || player.m_150109_().f_35974_.stream().limit(9L).anyMatch(stack -> stack.m_41720_() == ModItems.THERMOMETER) || player.m_21206_().m_41720_() == ModItems.THERMOMETER;
            this.showBodyTemp = !player.m_7500_() && !player.m_5833_();
        }
        this.setTemp(Temperature.Type.BASE, newBaseTemp);
        this.setTemp(Temperature.Type.CORE, CSMath.clamp(newCoreTemp, -150.0, 150.0));
        this.setTemp(Temperature.Type.WORLD, newWorldTemp);
        this.setTemp(Temperature.Type.MAX, newMaxOffset);
        this.setTemp(Temperature.Type.MIN, newMinOffset);
        double d = this.ticksSinceSync;
        this.ticksSinceSync = d + 1.0;
        if (d >= 5.0 && (Math.abs(this.syncedValues[0] - newCoreTemp) >= 1.0 && this.showBodyTemp || Math.abs(this.syncedValues[1] - newBaseTemp) >= 1.0 && this.showBodyTemp || Math.abs(this.syncedValues[2] - newWorldTemp) >= 0.02 && this.showWorldTemp || Math.abs(this.syncedValues[3] - newMaxOffset) >= 0.02 && this.showWorldTemp || Math.abs(this.syncedValues[4] - newMinOffset) >= 0.02 && this.showWorldTemp)) {
            TempHelper.updateTemperature(player, this, false);
            this.syncedValues = new double[]{newCoreTemp, newBaseTemp, newWorldTemp, newMaxOffset, newMinOffset};
            this.ticksSinceSync = 0.0;
        }
        double bodyTemp = this.getTemp(Temperature.Type.BODY);
        if (player.f_19797_ % 40 == 0) {
            boolean damageScaling = config.damageScaling;
            if (!(!(bodyTemp >= 100.0) || player.m_21023_(MobEffects.f_19607_) && config.fireRes || player.m_21023_(ModEffects.GRACE))) {
                player.m_6469_(damageScaling ? ModDamageSources.HOT.m_19386_() : ModDamageSources.HOT, 2.0f);
            } else if (!(!(bodyTemp <= -100.0) || player.m_21023_(ModEffects.ICE_RESISTANCE) && config.iceRes || player.m_21023_(ModEffects.GRACE))) {
                player.m_6469_(damageScaling ? ModDamageSources.COLD.m_19386_() : ModDamageSources.COLD, 2.0f);
            }
        }
    }

    private double getBodyReturnRate(double worldTemp, double tempLimit, double tempRate, double bodyTemp) {
        double staticRate = 3.0;
        double changeBy = Math.max(Math.abs(worldTemp - tempLimit) / staticRate * tempRate, tempRate / 10.0) * (double)(-CSMath.getSign(bodyTemp));
        return CSMath.getLeastExtreme(changeBy, -bodyTemp);
    }

    public void copy(PlayerTempCap cap) {
        for (Temperature.Type type : Temperature.Type.values()) {
            if (type == Temperature.Type.BODY || type == Temperature.Type.RATE) continue;
            this.setTemp(type, cap.getTemp(type));
        }
        for (Temperature.Type type : VALID_MODIFIER_TYPES) {
            this.getModifiers(type).clear();
            this.getModifiers(type).addAll(cap.getModifiers(type));
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = this.serializeTemps();
        nbt.m_128391_(this.serializeModifiers());
        return nbt;
    }

    public CompoundTag serializeTemps() {
        CompoundTag nbt = new CompoundTag();
        for (Temperature.Type type : VALID_TEMPERATURE_TYPES) {
            nbt.m_128347_(TempHelper.getTempTag(type), this.getTemp(type));
        }
        return nbt;
    }

    public CompoundTag serializeModifiers() {
        CompoundTag nbt = new CompoundTag();
        for (Temperature.Type type : VALID_MODIFIER_TYPES) {
            ListTag modifiers = new ListTag();
            for (TempModifier modifier : this.getModifiers(type)) {
                modifiers.add((Object)NBTHelper.modifierToTag(modifier));
            }
            nbt.m_128365_(TempHelper.getModifierTag(type), (Tag)modifiers);
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.deserializeTemps(nbt);
        this.deserializeModifiers(nbt);
    }

    public void deserializeTemps(CompoundTag nbt) {
        for (Temperature.Type type : VALID_TEMPERATURE_TYPES) {
            this.setTemp(type, nbt.m_128459_(TempHelper.getTempTag(type)));
        }
    }

    public void deserializeModifiers(CompoundTag nbt) {
        for (Temperature.Type type : VALID_MODIFIER_TYPES) {
            this.getModifiers(type).clear();
            ListTag modifiers = nbt.m_128437_(TempHelper.getModifierTag(type), 10);
            modifiers.forEach(modNBT -> {
                TempModifier modifier = NBTHelper.tagToModifier((CompoundTag)modNBT);
                if (modifier != null) {
                    this.getModifiers(type).add(modifier);
                } else {
                    ColdSweat.LOGGER.error("Failed to load modifier of type {}", (Object)type);
                }
            });
        }
    }
}

