/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.common.command.impl;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.api.util.TempHelper;
import dev.momostudios.coldsweat.common.capability.ModCapabilities;
import dev.momostudios.coldsweat.common.command.BaseCommand;
import java.util.Collection;
import java.util.Comparator;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class TempCommand
extends BaseCommand {
    public TempCommand(String name, int permissionLevel, boolean enabled) {
        super(name, permissionLevel, enabled);
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> setExecution() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)this.builder.then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)-150, (int)150)).executes(source -> this.executeSetPlayerTemp((CommandSourceStack)source.getSource(), EntityArgument.m_91477_((CommandContext)source, (String)"players"), IntegerArgumentType.getInteger((CommandContext)source, (String)"amount"))))))).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(source -> this.executeGetPlayerTemp((CommandSourceStack)source.getSource(), EntityArgument.m_91477_((CommandContext)source, (String)"players")))));
    }

    private int executeSetPlayerTemp(CommandSourceStack source, Collection<ServerPlayer> players, int temp) {
        for (ServerPlayer player : players) {
            player.getCapability(ModCapabilities.PLAYER_TEMPERATURE).ifPresent(cap -> {
                cap.setTemp(Temperature.Type.CORE, temp);
                TempHelper.updateTemperature((Player)player, cap, true);
            });
        }
        if (players.size() == 1) {
            Player target = (Player)players.iterator().next();
            source.m_81354_((Component)new TranslatableComponent("commands.cold_sweat.temperature.set.single.result", new Object[]{target.m_7755_().getString(), temp}), true);
        } else {
            source.m_81354_((Component)new TranslatableComponent("commands.cold_sweat.temperature.set.many.result", new Object[]{players.size(), temp}), true);
        }
        return 1;
    }

    private int executeGetPlayerTemp(CommandSourceStack source, Collection<ServerPlayer> players) {
        for (ServerPlayer target : players.stream().sorted(Comparator.comparing(player -> player.m_7755_().getString())).toList()) {
            int bodyTemp = (int)TempHelper.getTemperature((Player)target, Temperature.Type.BODY).get();
            source.m_81354_((Component)new TranslatableComponent("commands.cold_sweat.temperature.get.result", new Object[]{target.m_7755_().getString(), bodyTemp}), false);
        }
        return 1;
    }
}

