/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.common.event;

import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.api.temperature.modifier.InsulationTempModifier;
import dev.momostudios.coldsweat.api.util.TempHelper;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import java.util.Map;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cold_sweat", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ArmorInsulation {
    @SubscribeEvent
    public static void addLeatherModifiers(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (event.phase == TickEvent.Phase.END && !player.f_19853_.m_5776_() && player.f_19797_ % 10 == 0) {
            Map<Item, Double> insulatingArmors = ConfigSettings.INSULATING_ARMORS.get();
            int insulation = 0;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack armorStack;
                Item item;
                if (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND || !((item = (armorStack = player.m_6844_(slot)).m_41720_()) instanceof ArmorItem)) continue;
                ArmorItem armorItem = (ArmorItem)item;
                insulation += armorItem.m_40404_();
                Number insulationValue = insulatingArmors.get(armorStack.m_41720_());
                if (insulationValue != null) {
                    insulation += insulationValue.intValue();
                    continue;
                }
                if (!armorStack.m_41784_().m_128471_("insulated")) continue;
                insulation += ArmorInsulation.getSlotWeight(slot);
            }
            InsulationTempModifier currentMod = TempHelper.getModifier(player, Temperature.Type.RATE, InsulationTempModifier.class);
            if (currentMod == null || (Integer)currentMod.getArgument("warmth") != insulation) {
                if (insulation == 0 && currentMod != null) {
                    TempHelper.removeModifiers(player, Temperature.Type.RATE, mod -> mod instanceof InsulationTempModifier);
                } else {
                    TempHelper.replaceModifier(player, new InsulationTempModifier(insulation).tickRate(10), Temperature.Type.RATE);
                }
            }
        }
    }

    static int getSlotWeight(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.HEAD -> 4;
            case EquipmentSlot.CHEST -> 7;
            case EquipmentSlot.LEGS -> 6;
            case EquipmentSlot.FEET -> 3;
            default -> 0;
        };
    }
}

