/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.common.event;

import com.mojang.datafixers.util.Pair;
import dev.momostudios.coldsweat.api.event.common.BlockChangedEvent;
import dev.momostudios.coldsweat.common.blockentity.HearthBlockEntity;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HearthPathManagement {
    public static LinkedHashMap<BlockPos, Integer> HEARTH_POSITIONS = new LinkedHashMap();
    public static final Set<Pair<BlockPos, String>> DISABLED_HEARTHS = new HashSet<Pair<BlockPos, String>>();

    @SubscribeEvent
    public static void onBlockUpdated(BlockChangedEvent event) {
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        if (event.getPrevState().m_60808_((BlockGetter)level, pos) != event.getNewState().m_60808_((BlockGetter)level, pos)) {
            for (Map.Entry<BlockPos, Integer> entry : HEARTH_POSITIONS.entrySet()) {
                BlockEntity blockEntity;
                int range;
                BlockPos hearthPos = entry.getKey();
                if (!pos.m_123314_((Vec3i)hearthPos, (double)(range = entry.getValue().intValue())) || !((blockEntity = level.m_7702_(hearthPos)) instanceof HearthBlockEntity)) continue;
                HearthBlockEntity hearth = (HearthBlockEntity)blockEntity;
                hearth.sendBlockUpdate(pos);
            }
        }
    }

    @SubscribeEvent
    public static void saveDisabledHearths(PlayerEvent.PlayerLoggedOutEvent event) {
        event.getPlayer().getPersistentData().m_128365_("disabledHearths", (Tag)HearthPathManagement.serializeDisabledHearths());
    }

    public static CompoundTag serializeDisabledHearths() {
        CompoundTag disabledHearths = new CompoundTag();
        int i = 0;
        for (Pair<BlockPos, String> pair : DISABLED_HEARTHS) {
            CompoundTag hearthData = new CompoundTag();
            hearthData.m_128356_("pos", ((BlockPos)pair.getFirst()).m_121878_());
            hearthData.m_128359_("level", (String)pair.getSecond());
            disabledHearths.m_128365_(String.valueOf(i), (Tag)hearthData);
            ++i;
        }
        return disabledHearths;
    }

    @SubscribeEvent
    public static void loadDisabledHearths(PlayerEvent.PlayerLoggedInEvent event) {
        HearthPathManagement.deserializeDisabledHearths(event.getPlayer().getPersistentData().m_128469_("disabledHearths"));
    }

    public static void deserializeDisabledHearths(CompoundTag disabledHearths) {
        DISABLED_HEARTHS.clear();
        for (String key : disabledHearths.m_128431_()) {
            CompoundTag hearthData = disabledHearths.m_128469_(key);
            DISABLED_HEARTHS.add((Pair<BlockPos, String>)Pair.of((Object)BlockPos.m_122022_((long)hearthData.m_128454_("pos")), (Object)hearthData.m_128461_("level")));
        }
    }

    @SubscribeEvent
    public static void onServerClosed(ServerStoppedEvent event) {
        HEARTH_POSITIONS.clear();
    }
}

