/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.common.item;

import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.api.temperature.modifier.WaterskinTempModifier;
import dev.momostudios.coldsweat.api.util.TempHelper;
import dev.momostudios.coldsweat.core.event.TaskScheduler;
import dev.momostudios.coldsweat.core.init.ItemInit;
import dev.momostudios.coldsweat.core.itemgroup.ColdSweatGroup;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import dev.momostudios.coldsweat.util.math.CSMath;
import dev.momostudios.coldsweat.util.registries.ModItems;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FilledWaterskinItem
extends Item {
    public FilledWaterskinItem() {
        super(new Item.Properties().m_41491_((CreativeModeTab)ColdSweatGroup.COLD_SWEAT).m_41487_(1).m_41495_((Item)ItemInit.WATERSKIN.get()));
    }

    public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean isSelected) {
        super.m_6883_(itemstack, world, entity, slot, isSelected);
        if (entity.f_19797_ % 5 == 0 && entity instanceof Player) {
            Player player = (Player)entity;
            double itemTemp = itemstack.m_41784_().m_128459_("temperature");
            if (itemTemp != 0.0 && slot <= 8 || player.m_21206_().equals(itemstack)) {
                double temp = 0.1 * ConfigSettings.getInstance().rate * (double)CSMath.getSign(itemTemp);
                double newTemp = itemTemp - temp;
                if (CSMath.isInRange(newTemp, -1.0, 1.0)) {
                    newTemp = 0.0;
                }
                itemstack.m_41784_().m_128347_("temperature", newTemp);
                TempHelper.addModifier(player, new WaterskinTempModifier(temp / 1.5).expires(5), Temperature.Type.CORE, true);
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        InteractionResultHolder ar = super.m_7203_(level, player, hand);
        ItemStack itemstack = (ItemStack)ar.m_19095_();
        double amount = itemstack.m_41784_().m_128459_("temperature") * ((double)ConfigSettings.WATERSKIN_STRENGTH.get().intValue() / 50.0);
        TempHelper.addModifier(player, new WaterskinTempModifier(amount).expires(0), Temperature.Type.CORE, true);
        level.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12590_, SoundSource.PLAYERS, 1.0f, (float)(Math.random() / 5.0 + 0.9), false);
        ItemStack emptyWaterskin = new ItemStack((ItemLike)ModItems.WATERSKIN);
        emptyWaterskin.m_41751_(itemstack.m_41783_());
        emptyWaterskin.m_41749_("temperature");
        if (player.m_150109_().m_36063_(emptyWaterskin)) {
            player.m_36356_(emptyWaterskin);
            player.m_21008_(hand, ItemStack.f_41583_);
        } else {
            player.m_21008_(hand, emptyWaterskin);
        }
        player.m_6674_(hand);
        Random rand = new Random();
        for (int i = 0; i < 6; ++i) {
            TaskScheduler.scheduleClient(() -> {
                for (int p = 0; p < rand.nextInt(5) + 5; ++p) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123804_, player.m_20185_() + (double)(rand.nextFloat() * player.m_20205_()) - (double)(player.m_20205_() / 2.0f), player.m_20186_() + (double)player.m_20206_() + (double)rand.nextFloat() * 0.5, player.m_20189_() + (double)(rand.nextFloat() * player.m_20205_()) - (double)(player.m_20205_() / 2.0f), 0.3, 0.3, 0.3);
                }
            }, i);
        }
        player.m_36335_().m_41524_(ModItems.FILLED_WATERSKIN, 10);
        player.m_36335_().m_41524_(ModItems.WATERSKIN, 10);
        return ar;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public String m_5524_() {
        return new TranslatableComponent("item.cold_sweat.waterskin").getString();
    }
}

