/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.config;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ClientSettingsConfig {
    private static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.Builder BUILDER;
    private static final ForgeConfigSpec.BooleanValue celsius;
    private static final ForgeConfigSpec.IntValue tempOffset;
    private static final ForgeConfigSpec.IntValue bodyIconX;
    private static final ForgeConfigSpec.IntValue bodyIconY;
    private static final ForgeConfigSpec.IntValue bodyReadoutX;
    private static final ForgeConfigSpec.IntValue bodyReadoutY;
    private static final ForgeConfigSpec.IntValue worldGaugeX;
    private static final ForgeConfigSpec.IntValue worldGaugeY;
    private static final ForgeConfigSpec.BooleanValue customHotbarLayout;
    private static final ForgeConfigSpec.BooleanValue iconBobbing;
    private static final ForgeConfigSpec.BooleanValue hearthDebug;

    public static void setup() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path csConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "coldsweat");
        try {
            Files.createDirectory(csConfigPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SPEC, "coldsweat/client.toml");
    }

    public static ClientSettingsConfig getInstance() {
        return new ClientSettingsConfig();
    }

    public boolean celsius() {
        return (Boolean)celsius.get();
    }

    public int tempOffset() {
        return (Integer)tempOffset.get();
    }

    public int bodyIconX() {
        return (Integer)bodyIconX.get();
    }

    public int bodyIconY() {
        return (Integer)bodyIconY.get();
    }

    public int bodyReadoutX() {
        return (Integer)bodyReadoutX.get();
    }

    public int bodyReadoutY() {
        return (Integer)bodyReadoutY.get();
    }

    public int worldGaugeX() {
        return (Integer)worldGaugeX.get();
    }

    public int worldGaugeY() {
        return (Integer)worldGaugeY.get();
    }

    public boolean customHotbar() {
        return (Boolean)customHotbarLayout.get();
    }

    public boolean iconBobbing() {
        return (Boolean)iconBobbing.get();
    }

    public boolean hearthDebug() {
        return (Boolean)hearthDebug.get();
    }

    public void setCelsius(boolean enabled) {
        celsius.set((Object)enabled);
    }

    public void setTempOffset(int offset) {
        tempOffset.set((Object)offset);
    }

    public void setBodyIconX(int pos) {
        bodyIconX.set((Object)pos);
    }

    public void setBodyIconY(int pos) {
        bodyIconY.set((Object)pos);
    }

    public void setBodyReadoutX(int pos) {
        bodyReadoutX.set((Object)pos);
    }

    public void setBodyReadoutY(int pos) {
        bodyReadoutY.set((Object)pos);
    }

    public void setWorldGaugeX(int pos) {
        worldGaugeX.set((Object)pos);
    }

    public void setWorldGaugeY(int pos) {
        worldGaugeY.set((Object)pos);
    }

    public void setCustomHotbar(boolean enabled) {
        customHotbarLayout.set((Object)enabled);
    }

    public void setIconBobbing(boolean enabled) {
        iconBobbing.set((Object)enabled);
    }

    public void setHearthDebug(boolean enabled) {
        hearthDebug.set((Object)enabled);
    }

    public void save() {
        SPEC.save();
    }

    static {
        BUILDER = new ForgeConfigSpec.Builder();
        BUILDER.push("Temperature display preferences");
        celsius = BUILDER.comment("Sets all temperatures to be displayed in Celsius").define("Celsius", false);
        tempOffset = BUILDER.comment("(Visually) offsets the temperature for personalization (default: 0, so a Plains biome is 75 \u00b0F or 21 \u00b0C)").defineInRange("Temperature Offset", 0, 0, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.push("Position of the 'Steve Head' temperature gauge above the hotbar");
        bodyIconX = BUILDER.comment("The x position of the gauge relative to its normal position").defineInRange("Temp. Icon X Offset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        bodyIconY = BUILDER.comment("The y position of the gauge relative to its normal position").defineInRange("Temp. Icon Y Offset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.push("Position of the temperature number below the icon");
        bodyReadoutX = BUILDER.comment("The x position of the temperature gauge relative to default").defineInRange("Temp. Readout X Offset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        bodyReadoutY = BUILDER.comment("The y position of the temperature gauge relative to default").defineInRange("Temp. Readout Y Offset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.push("Position of the world temperature gauge beside the hotbar");
        worldGaugeX = BUILDER.comment("The x position of the temperature gauge relative to default").defineInRange("Temp. Gauge X Offset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        worldGaugeY = BUILDER.comment("The y position of the temperature gauge relative to default").defineInRange("Temp. Gauge Y Offset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.push("UI Options");
        customHotbarLayout = BUILDER.define("Custom hotbar layout", true);
        iconBobbing = BUILDER.comment("Controls whether the temperature icon shakes when in critical condition").define("Icon Bobbing", true);
        BUILDER.pop();
        hearthDebug = BUILDER.comment("Displays areas that the Hearth affecting when the F3 debug menu is open").define("Hearth Debug", true);
        SPEC = BUILDER.build();
    }
}

