/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.config;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public final class ItemSettingsConfig {
    private static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.Builder BUILDER;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> boilerItems;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> iceboxItems;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> hearthItems;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> soulLampItems;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> soulLampDimensions;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> insulatingItems;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> insulatingArmor;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> temperatureFoods;
    private static final ForgeConfigSpec.IntValue waterskinStrength;
    static final ItemSettingsConfig INSTANCE;

    public static void setup() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path csConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "coldsweat");
        try {
            Files.createDirectory(csConfigPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "coldsweat/item_settings.toml");
    }

    public void copyValues(ItemSettingsConfig config) {
        this.setBoilerItems(config.boilerItems());
        this.setIceboxItems(config.iceboxItems());
        this.setHearthItems(config.hearthItems());
        this.setInsulatingItems(config.insulatingItems());
        this.setInsulatingArmor(config.insulatingArmor());
        this.setSoulLampDimensions(config.soulLampDimensions());
        this.setSoulLampItems(config.soulLampItems());
        this.setTemperatureFoods(config.temperatureFoods());
        this.setWaterskinStrength(config.waterskinStrength());
    }

    public static ItemSettingsConfig getInstance() {
        return INSTANCE;
    }

    public List<? extends List<?>> boilerItems() {
        return (List)boilerItems.get();
    }

    public List<? extends List<?>> iceboxItems() {
        return (List)iceboxItems.get();
    }

    public List<? extends List<?>> hearthItems() {
        return (List)hearthItems.get();
    }

    public List<? extends String> insulatingItems() {
        return (List)insulatingItems.get();
    }

    public List<? extends List<?>> insulatingArmor() {
        return (List)insulatingArmor.get();
    }

    public List<? extends String> soulLampItems() {
        return (List)soulLampItems.get();
    }

    public List<? extends List<?>> temperatureFoods() {
        return (List)temperatureFoods.get();
    }

    public List<? extends String> soulLampDimensions() {
        return (List)soulLampDimensions.get();
    }

    public int waterskinStrength() {
        return (Integer)waterskinStrength.get();
    }

    public void setBoilerItems(List<? extends List<?>> itemMap) {
        boilerItems.set(itemMap);
    }

    public void setIceboxItems(List<? extends List<?>> itemMap) {
        iceboxItems.set(itemMap);
    }

    public void setHearthItems(List<? extends List<?>> itemMap) {
        hearthItems.set(itemMap);
    }

    public void setInsulatingItems(List<? extends String> items) {
        insulatingItems.set(items);
    }

    public void setInsulatingArmor(List<? extends List<?>> itemMap) {
        insulatingArmor.set(itemMap);
    }

    public void setSoulLampItems(List<? extends String> items) {
        soulLampItems.set(items);
    }

    public void setTemperatureFoods(List<? extends List<?>> itemMap) {
        temperatureFoods.set(itemMap);
    }

    public void setSoulLampDimensions(List<? extends String> items) {
        soulLampDimensions.set(items);
    }

    public void setWaterskinStrength(int strength) {
        waterskinStrength.set((Object)strength);
    }

    static {
        BUILDER = new ForgeConfigSpec.Builder();
        INSTANCE = new ItemSettingsConfig();
        BUILDER.push("Fuel Items").comment(new String[]{"Defines items that can use as fuel", "Format: [[\"item-id-1\", amount-1], [\"item-id-2\", amount-2], ...etc]"});
        boilerItems = BUILDER.defineList("Boiler", Arrays.asList(Arrays.asList("minecraft:coal", 37), Arrays.asList("minecraft:charcoal", 37), Arrays.asList("minecraft:coal_block", 333), Arrays.asList("minecraft:magma_block", 333), Arrays.asList("minecraft:lava_bucket", 1000)), it -> it instanceof List && ((List)it).get(0) instanceof String && ((List)it).get(1) instanceof Number);
        iceboxItems = BUILDER.defineList("Icebox", Arrays.asList(Arrays.asList("minecraft:snowball", 37), Arrays.asList("minecraft:clay", 37), Arrays.asList("minecraft:snow_block", 333), Arrays.asList("minecraft:water_bucket", 333), Arrays.asList("minecraft:ice", 333), Arrays.asList("minecraft:packed_ice", 1000)), it -> it instanceof List && ((List)it).get(0) instanceof String && ((List)it).get(1) instanceof Number);
        hearthItems = BUILDER.comment("Negative values indicate cold fuel").defineList("Hearth", Arrays.asList(Arrays.asList("minecraft:coal", 37), Arrays.asList("minecraft:charcoal", 37), Arrays.asList("minecraft:coal_block", 333), Arrays.asList("minecraft:magma_block", 333), Arrays.asList("minecraft:lava_bucket", 1000), Arrays.asList("minecraft:snowball", -37), Arrays.asList("minecraft:clay", -37), Arrays.asList("minecraft:snow_block", -333), Arrays.asList("minecraft:water_bucket", -333), Arrays.asList("minecraft:ice", -333), Arrays.asList("minecraft:packed_ice", -1000)), it -> it instanceof List && ((List)it).get(0) instanceof String && ((List)it).get(1) instanceof Number);
        BUILDER.pop();
        BUILDER.push("Soulspring Lamp");
        soulLampItems = BUILDER.comment(new String[]{"Defines the items that the Soulspring Lamp can use as fuel and their values", "Format: [\"item-id-1\", \"item-id-2\", ...etc]"}).defineList("Fuel Items", Arrays.asList("minecraft:warped_stem", "minecraft:warped_hyphae", "minecraft:stripped_warped_stem", "minecraft:stripped_warped_hyphae", "minecraft:crimson_stem", "minecraft:crimson_hyphae", "minecraft:stripped_crimson_stem", "minecraft:stripped_crimson_hyphae"), it -> it instanceof String);
        soulLampDimensions = BUILDER.comment(new String[]{"Defines the dimensions that the Soulspring Lamp can be used in", "Format: [\"dimension-id-1\", \"dimension-id-2\", ...etc]"}).defineList("Valid Dimensions", Arrays.asList("minecraft:the_nether"), it -> it instanceof String);
        BUILDER.pop();
        BUILDER.push("Insulation");
        insulatingItems = BUILDER.comment(new String[]{"Defines the items that can be used for insulating armor in the Sewing Table", "Format: [[\"item-id-1\"], [\"item-id-2\"], ...etc]"}).defineList("Insulation Ingredients", Arrays.asList("minecraft:leather_helmet", "minecraft:leather_chestplate", "minecraft:leather_leggings", "minecraft:leather_boots"), it -> it instanceof String);
        insulatingArmor = BUILDER.comment(new String[]{"Defines the items that provide insulation when worn", "Format: [[\"item-id-1\", amount-1], [\"item-id-2\", amount-2], ...etc]"}).defineList("Insulated Armor", Arrays.asList(Arrays.asList("minecraft:leather_helmet", 4), Arrays.asList("minecraft:leather_chestplate", 7), Arrays.asList("minecraft:leather_leggings", 5), Arrays.asList("minecraft:leather_boots", 4)), it -> it instanceof List && ((List)it).get(0) instanceof String && ((List)it).get(1) instanceof Number);
        BUILDER.pop();
        BUILDER.push("Consumables");
        temperatureFoods = BUILDER.comment(new String[]{"Defines items that affect the player's temperature when consumed", "Format: [[item-id-1, amount-1], [item-id-2, amount-2], ...etc]", "Negative values are cold foods, positive values are hot foods"}).defineList("Temperature-Affecting Foods", Arrays.asList(new List[0]), it -> it instanceof List && ((List)it).get(0) instanceof String && ((List)it).get(1) instanceof Number);
        waterskinStrength = BUILDER.comment("Defines the amount a player's body temperature will change by when using a waterskin").defineInRange("Waterskin Strength", 50, 0, Integer.MAX_VALUE);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

