/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.config;

import dev.momostudios.coldsweat.ColdSweat;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class WorldSettingsConfig {
    private static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.Builder BUILDER;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> biomeOffsets;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> biomeTemps;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> dimensionOffsets;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> dimensionTemps;
    public static ForgeConfigSpec.ConfigValue<List<? extends Number>> summerTemps;
    public static ForgeConfigSpec.ConfigValue<List<? extends Number>> autumnTemps;
    public static ForgeConfigSpec.ConfigValue<List<? extends Number>> winterTemps;
    public static ForgeConfigSpec.ConfigValue<List<? extends Number>> springTemps;
    static final WorldSettingsConfig INSTANCE;

    public static void setup() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path csConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "coldsweat");
        try {
            Files.createDirectory(csConfigPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "coldsweat/world_settings.toml");
    }

    public static WorldSettingsConfig getInstance() {
        return INSTANCE;
    }

    public List<? extends List<?>> biomeOffsets() {
        return (List)biomeOffsets.get();
    }

    public List<? extends List<?>> biomeTemperatures() {
        return (List)biomeTemps.get();
    }

    public List<? extends List<?>> dimensionOffsets() {
        return (List)dimensionOffsets.get();
    }

    public List<? extends List<?>> dimensionTemperatures() {
        return (List)dimensionTemps.get();
    }

    public Double[] summerTemps() {
        return (Double[])((List)summerTemps.get()).stream().map(Number::doubleValue).toArray(Double[]::new);
    }

    public Double[] autumnTemps() {
        return (Double[])((List)autumnTemps.get()).stream().map(Number::doubleValue).toArray(Double[]::new);
    }

    public Double[] winterTemps() {
        return (Double[])((List)winterTemps.get()).stream().map(Number::doubleValue).toArray(Double[]::new);
    }

    public Double[] springTemps() {
        return (Double[])((List)springTemps.get()).stream().map(Number::doubleValue).toArray(Double[]::new);
    }

    public void setBiomeOffsets(List<? extends List<?>> list) {
        biomeOffsets.set(list);
    }

    public void setDimensionOffsets(List<? extends List<?>> list) {
        dimensionOffsets.set(list);
    }

    public void setBiomeTemperatures(List<? extends List<?>> list) {
        biomeTemps.set(list);
    }

    public void setDimensionTemperatures(List<? extends List<?>> list) {
        dimensionTemps.set(list);
    }

    static {
        BUILDER = new ForgeConfigSpec.Builder();
        summerTemps = null;
        autumnTemps = null;
        winterTemps = null;
        springTemps = null;
        INSTANCE = new WorldSettingsConfig();
        BUILDER.comment(new String[]{"Format: [[\"dimension-1\", temperature-1], [\"dimension-2\", temperature-2]... etc]", "Common dimension IDs: minecraft:overworld, minecraft:the_nether, minecraft:the_end", "Note: all temperatures are in Minecraft units", "\u00b0F to MC = (x - 32) / 42", "\u00b0C to MC = x / 23.3"}).push("Dimensions");
        dimensionOffsets = BUILDER.comment("Applies an offset to the world's temperature across an entire dimension").defineList("Dimension Temperature Offsets", List.of(List.of("minecraft:the_nether", Double.valueOf(0.7)), List.of("minecraft:the_end", Double.valueOf(-0.1))), it -> it instanceof List && ((List)it).get(0) instanceof String && ((List)it).get(1) instanceof Number);
        dimensionTemps = BUILDER.comment(new String[]{"Overrides existing dimension temperatures & offsets", "Also overrides temperatures of all biomes in the dimension"}).defineList("Dimension Temperatures", List.of(), it -> it instanceof List && ((List)it).get(0) instanceof String && ((List)it).get(1) instanceof Number);
        BUILDER.pop();
        BUILDER.comment(new String[]{"Format: [[\"biome-1\", temp-low, temp-high, *units], [\"biome-2\", temp-low, temp-high, *units]... etc]", "temp-low: The temperature of the biome at midnight", "temp-high: The temperature of the biome at noon", "units: Optional. The units of the temperature (\"C\" or \"F\". Defaults to MC units)", "Note: all temperatures are in Minecraft units"}).push("Biomes");
        ArrayList<List> biomeBuilder = new ArrayList<List>(List.of(List.of("minecraft:soul_sand_valley", Integer.valueOf(33), Integer.valueOf(33), "F"), List.of("minecraft:old_growth_birch_forest", Integer.valueOf(58), Integer.valueOf(72), "F"), List.of("minecraft:river", Integer.valueOf(60), Integer.valueOf(70), "F"), List.of("minecraft:swamp", Integer.valueOf(72), Integer.valueOf(84), "F"), List.of("minecraft:savanna", Integer.valueOf(70), Integer.valueOf(95), "F"), List.of("minecraft:savanna_plateau", Integer.valueOf(76), Integer.valueOf(98), "F"), List.of("minecraft:windswept_savanna", Integer.valueOf(67), Integer.valueOf(90), "F"), List.of("minecraft:taiga", Integer.valueOf(44), Integer.valueOf(62), "F"), List.of("minecraft:snowy_taiga", Integer.valueOf(28), Integer.valueOf(52), "F"), List.of("minecraft:old_growth_pine_taiga", Integer.valueOf(48), Integer.valueOf(62), "F"), List.of("minecraft:old_growth_spruce_taiga", Integer.valueOf(48), Integer.valueOf(62), "F"), List.of("minecraft:desert", Integer.valueOf(57), Integer.valueOf(115), "F"), List.of("minecraft:stony_shore", Integer.valueOf(50), Integer.valueOf(60), "F"), List.of("minecraft:snowy_beach", Integer.valueOf(38), Integer.valueOf(52), "F"), List.of("minecraft:snowy_slopes", Integer.valueOf(24), Integer.valueOf(38), "F"), List.of("minecraft:windswept_forest", Integer.valueOf(48), Integer.valueOf(56), "F"), List.of("minecraft:frozen_peaks", Integer.valueOf(15), Integer.valueOf(33), "F"), List.of("minecraft:warm_ocean", Integer.valueOf(67), Integer.valueOf(76), "F"), List.of("minecraft:deep_frozen_ocean", Integer.valueOf(56), Integer.valueOf(65), "F"), List.of("minecraft:badlands", Integer.valueOf(84), Integer.valueOf(120), "F"), List.of("minecraft:wooded_badlands", Integer.valueOf(80), Integer.valueOf(108), "F"), List.of("minecraft:eroded_badlands", Integer.valueOf(88), Integer.valueOf(120), "F")));
        if (ModList.get().isLoaded("biomesoplenty")) {
            biomeBuilder.addAll(List.of(List.of("biomesoplenty:bayou", Integer.valueOf(67), Integer.valueOf(78), "F"), List.of("biomesoplenty:bog", Integer.valueOf(62), Integer.valueOf(73), "F"), List.of("biomesoplenty:fir_clearing", Integer.valueOf(56), Integer.valueOf(68), "F"), List.of("biomesoplenty:marsh", Integer.valueOf(76), Integer.valueOf(87), "F"), List.of("biomesoplenty:wetland", Integer.valueOf(63), Integer.valueOf(74), "F"), List.of("biomesoplenty:field", Integer.valueOf(64), Integer.valueOf(85), "F"), List.of("biomesoplenty:ominous_woods", Integer.valueOf(65), Integer.valueOf(72), "F"), List.of("biomesoplenty:coniferous_forest", Integer.valueOf(44), Integer.valueOf(58), "F"), List.of("biomesoplenty:seasonal_forest", Integer.valueOf(52), Integer.valueOf(64), "F"), List.of("biomesoplenty:pumpkin_patch", Integer.valueOf(57), Integer.valueOf(78), "F"), List.of("biomesoplenty:woodland", Integer.valueOf(67), Integer.valueOf(80), "F"), List.of("biomesoplenty:mediterranean_forest", Integer.valueOf(64), Integer.valueOf(78), "F"), List.of("biomesoplenty:dune_beach", Integer.valueOf(67), Integer.valueOf(78), "F"), List.of("biomesoplenty:rocky_rainforest", Integer.valueOf(73), Integer.valueOf(86), "F"), List.of("biomesoplenty:old_growth_woodland", Integer.valueOf(65), Integer.valueOf(78), "F"), List.of("biomesoplenty:forested_field", Integer.valueOf(64), Integer.valueOf(78), "F"), List.of("biomesoplenty:fungal_jungle", Integer.valueOf(73), Integer.valueOf(86), "F"), List.of("biomesoplenty:highland", Integer.valueOf(57), Integer.valueOf(70), "F"), List.of("biomesoplenty:highland_moor", Integer.valueOf(54), Integer.valueOf(68), "F"), List.of("biomesoplenty:grassland", Integer.valueOf(58), Integer.valueOf(82), "F"), List.of("biomesoplenty:clover_patch", Integer.valueOf(56), Integer.valueOf(78), "F"), List.of("biomesoplenty:jade_cliffs", Integer.valueOf(57), Integer.valueOf(70), "F"), List.of("biomesoplenty:lush_desert", Integer.valueOf(72), Integer.valueOf(94), "F"), List.of("biomesoplenty:dryland", Integer.valueOf(67), Integer.valueOf(97), "F"), List.of("biomesoplenty:maple_woods", Integer.valueOf(58), Integer.valueOf(68), "F"), List.of("biomesoplenty:mystic_grove", Integer.valueOf(65), Integer.valueOf(72), "F"), List.of("biomesoplenty:orchard", Integer.valueOf(58), Integer.valueOf(78), "F"), List.of("biomesoplenty:prairie", Integer.valueOf(66), Integer.valueOf(82), "F"), List.of("biomesoplenty:origin_valley", Integer.valueOf(65), Integer.valueOf(80), "F"), List.of("biomesoplenty:snowy_coniferous_forest", Integer.valueOf(28), Integer.valueOf(48), "F"), List.of("biomesoplenty:snowy_fir_clearing", Integer.valueOf(32), Integer.valueOf(51), "F"), List.of("biomesoplenty:snowy_maple_woods", Integer.valueOf(32), Integer.valueOf(48), "F"), List.of("biomesoplenty:spider_nest", Integer.valueOf(75), Integer.valueOf(75), "F"), List.of("biomesoplenty:volcanic_plains", Integer.valueOf(82), Integer.valueOf(95), "F"), List.of("biomesoplenty:volcano", Integer.valueOf(94), Integer.valueOf(120), "F"), List.of("biomesoplenty:wooded_wasteland", Integer.valueOf(78), Integer.valueOf(95), "F")));
        }
        biomeOffsets = BUILDER.comment("Applies an offset to the temperature of a biome (in Minecraft units).").defineList("Biome Temperature Offsets", List.of(), it -> {
            if (it instanceof List) {
                List list = (List)it;
                if (list.size() == 2) {
                    ColdSweat.LOGGER.warn("Falling back to legacy code for config setting \"Biome Temperature Offsets\". Please update to the new standard!");
                }
                return !(!(list.get(0) instanceof String) || !(list.get(1) instanceof Number) || list.size() >= 3 && !(list.get(2) instanceof Number) || list.size() >= 4 && !(list.get(3) instanceof String));
            }
            return false;
        });
        biomeTemps = BUILDER.comment("Defines the temperature of a biome, overriding existing biome temperatures & offsets (in Minecraft units).").defineList("Biome Temperatures", biomeBuilder, it -> {
            if (it instanceof List) {
                List list = (List)it;
                if (list.size() == 2) {
                    ColdSweat.LOGGER.warn("Falling back to legacy code for config setting \"Biome Temperatures\". Please update to the new standard!");
                }
                return !(!(list.get(0) instanceof String) || !(list.get(1) instanceof Number) || list.size() >= 3 && !(list.get(2) instanceof Number) || list.size() >= 4 && !(list.get(3) instanceof String));
            }
            return false;
        });
        BUILDER.pop();
        if (ModList.get().isLoaded("sereneseasons")) {
            BUILDER.comment(new String[]{"Format: [season-start, season-mid, season-end]", "Applied as an offset to the world's temperature"}).push("Season Temperatures");
            summerTemps = BUILDER.defineList("Summer", Arrays.asList(0.4, 0.6, 0.4), it -> it instanceof Number);
            autumnTemps = BUILDER.defineList("Autumn", Arrays.asList(0.2, 0, -0.2), it -> it instanceof Number);
            winterTemps = BUILDER.defineList("Winter", Arrays.asList(-0.4, -0.6, -0.4), it -> it instanceof Number);
            springTemps = BUILDER.defineList("Spring", Arrays.asList(-0.2, 0, 0.2), it -> it instanceof Number);
            BUILDER.pop();
        }
        SPEC = BUILDER.build();
    }
}

