/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.core.init;

import dev.momostudios.coldsweat.ColdSweat;
import dev.momostudios.coldsweat.api.event.core.BlockTempRegisterEvent;
import dev.momostudios.coldsweat.api.event.core.TempModifierRegisterEvent;
import dev.momostudios.coldsweat.api.registry.BlockTempRegistry;
import dev.momostudios.coldsweat.api.registry.TempModifierRegistry;
import dev.momostudios.coldsweat.api.temperature.block_temp.BlockTemp;
import dev.momostudios.coldsweat.api.temperature.block_temp.BoilerBlockTemp;
import dev.momostudios.coldsweat.api.temperature.block_temp.CampfireBlockTemp;
import dev.momostudios.coldsweat.api.temperature.block_temp.FurnaceBlockTemp;
import dev.momostudios.coldsweat.api.temperature.block_temp.IceboxBlockTemp;
import dev.momostudios.coldsweat.api.temperature.block_temp.LavaBlockTemp;
import dev.momostudios.coldsweat.api.temperature.block_temp.NetherPortalBlockTemp;
import dev.momostudios.coldsweat.api.temperature.block_temp.SoulCampfireBlockTemp;
import dev.momostudios.coldsweat.api.temperature.modifier.BiomeTempModifier;
import dev.momostudios.coldsweat.api.temperature.modifier.BlockTempModifier;
import dev.momostudios.coldsweat.api.temperature.modifier.DepthTempModifier;
import dev.momostudios.coldsweat.api.temperature.modifier.FoodTempModifier;
import dev.momostudios.coldsweat.api.temperature.modifier.FreezingTempModifier;
import dev.momostudios.coldsweat.api.temperature.modifier.HearthTempModifier;
import dev.momostudios.coldsweat.api.temperature.modifier.InsulationTempModifier;
import dev.momostudios.coldsweat.api.temperature.modifier.MountTempModifier;
import dev.momostudios.coldsweat.api.temperature.modifier.SoulLampTempModifier;
import dev.momostudios.coldsweat.api.temperature.modifier.TempModifier;
import dev.momostudios.coldsweat.api.temperature.modifier.WaterTempModifier;
import dev.momostudios.coldsweat.api.temperature.modifier.WaterskinTempModifier;
import dev.momostudios.coldsweat.config.ColdSweatConfig;
import dev.momostudios.coldsweat.util.config.ConfigHelper;
import dev.momostudios.coldsweat.util.math.CSMath;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TempModifierInit {
    @SubscribeEvent
    public static void registerTempModifiers(ServerStartedEvent event) {
        TempModifierRegistry.flush();
        BlockTempRegistry.flush();
        try {
            MinecraftForge.EVENT_BUS.post((Event)new TempModifierRegisterEvent());
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("Registering TempModifiers failed!");
            e.printStackTrace();
        }
        try {
            MinecraftForge.EVENT_BUS.post((Event)new BlockTempRegisterEvent());
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("Registering BlockTemps failed!");
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void registerBlockTemps(BlockTempRegisterEvent event) {
        for (List<Object> list : ColdSweatConfig.getInstance().getBlockTemps()) {
            try {
                Number configTemp;
                Object object;
                block7: {
                    block6: {
                        if (!(list.get(0) instanceof String) || !((object = list.get(1)) instanceof Number)) break block6;
                        configTemp = (Number)object;
                        object = list.get(2);
                        if (object instanceof Number) break block7;
                    }
                    throw new Exception("Invalid BlockTemp format");
                }
                Number configRange = (Number)object;
                String[] blockIDs = ((String)list.get(0)).split(",");
                final double temp = configTemp.doubleValue();
                final double range = configRange.doubleValue();
                final boolean weaken = list.size() < 4 || !(list.get(2) instanceof Boolean) || (Boolean)list.get(3) != false;
                double maxChange = list.size() == 5 && list.get(4) instanceof Number ? ((Number)list.get(4)).doubleValue() : Double.MAX_VALUE;
                final double maxEffect = temp > 0.0 ? maxChange : Double.MAX_VALUE;
                final double minEffect = temp < 0.0 ? -maxChange : -1.7976931348623157E308;
                ArrayList<Block> effectBlocks = new ArrayList<Block>();
                for (String id : blockIDs) {
                    effectBlocks.addAll(ConfigHelper.getBlocks(id));
                }
                event.register(new BlockTemp(effectBlocks.toArray(new Block[0])){

                    @Override
                    public double getTemperature(Player player, BlockState state, BlockPos pos, double distance) {
                        return weaken ? CSMath.blend(temp, 0.0, distance, 0.5, range) : temp;
                    }

                    @Override
                    public double maxEffect() {
                        return maxEffect;
                    }

                    @Override
                    public double minEffect() {
                        return minEffect;
                    }
                });
            }
            catch (Exception e) {
                ColdSweat.LOGGER.error("Invalid configuration for BlockTemps in config file \"main.toml\"");
                e.printStackTrace();
                break;
            }
        }
        event.register(new LavaBlockTemp());
        event.register(new FurnaceBlockTemp());
        event.register(new CampfireBlockTemp());
        event.register(new IceboxBlockTemp());
        event.register(new BoilerBlockTemp());
        event.register(new SoulCampfireBlockTemp());
        event.register(new NetherPortalBlockTemp());
    }

    @SubscribeEvent
    public static void registerTempModifiers(TempModifierRegisterEvent event) {
        String sereneSeasons = "dev.momostudios.coldsweat.api.temperature.modifier.compat.SereneSeasonsTempModifier";
        event.register(new BlockTempModifier());
        event.register(new BiomeTempModifier());
        event.register(new DepthTempModifier());
        event.register(new InsulationTempModifier());
        event.register(new MountTempModifier());
        event.register(new WaterskinTempModifier());
        event.register(new SoulLampTempModifier());
        event.register(new WaterTempModifier());
        event.register(new HearthTempModifier());
        event.register(new FoodTempModifier());
        event.register(new FreezingTempModifier());
        if (ModList.get().isLoaded("sereneseasons")) {
            try {
                event.register((TempModifier)Class.forName(sereneSeasons).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

