/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.core.network.message;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PlaySoundMessage {
    static Constructor<?> SOUND_MAKER;
    static Method PLAY_METHOD;
    String sound;
    int soundChars;
    SoundSource source;
    float volume;
    float pitch;
    int entityID;

    public PlaySoundMessage(String sound, SoundSource source, float volume, float pitch, int entityID) {
        this.sound = sound;
        this.source = source;
        this.soundChars = sound.length();
        this.volume = volume;
        this.pitch = pitch;
        this.entityID = entityID;
    }

    public static void encode(PlaySoundMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.soundChars);
        buffer.writeCharSequence((CharSequence)message.sound, StandardCharsets.UTF_8);
        buffer.m_130068_((Enum)message.source);
        buffer.writeFloat(message.volume);
        buffer.writeFloat(message.pitch);
        buffer.writeInt(message.entityID);
    }

    public static PlaySoundMessage decode(FriendlyByteBuf buffer) {
        int soundChars = buffer.readInt();
        return new PlaySoundMessage(buffer.readCharSequence(soundChars, StandardCharsets.UTF_8).toString(), (SoundSource)buffer.m_130066_(SoundSource.class), buffer.readFloat(), buffer.readFloat(), buffer.readInt());
    }

    public static void handle(PlaySoundMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide().isClient()) {
                SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(message.sound));
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(message.entityID);
                if (entity != null && sound != null) {
                    try {
                        PLAY_METHOD.invoke((Object)Minecraft.m_91087_().m_91106_(), SOUND_MAKER.newInstance(sound, message.source, Float.valueOf(message.volume), Float.valueOf(message.pitch), entity));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        context.setPacketHandled(true);
    }

    static {
        try {
            SOUND_MAKER = ObfuscationReflectionHelper.findConstructor(Class.forName("net.minecraft.client.resources.sounds.EntityBoundSoundInstance"), (Class[])new Class[]{SoundEvent.class, SoundSource.class, Float.TYPE, Float.TYPE, Entity.class});
            PLAY_METHOD = ObfuscationReflectionHelper.findMethod(Class.forName("net.minecraft.client.sounds.SoundManager"), (String)"m_120367_", (Class[])new Class[]{Class.forName("net.minecraft.client.resources.sounds.SoundInstance")});
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

