/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.core.network.message;

import dev.momostudios.coldsweat.common.capability.ModCapabilities;
import dev.momostudios.coldsweat.common.capability.PlayerTempCap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PlayerModifiersSyncMessage {
    CompoundTag modifiers;

    public PlayerModifiersSyncMessage(CompoundTag modifiers) {
        this.modifiers = modifiers;
    }

    public static void encode(PlayerModifiersSyncMessage message, FriendlyByteBuf buffer) {
        buffer.m_130079_(message.modifiers);
    }

    public static PlayerModifiersSyncMessage decode(FriendlyByteBuf buffer) {
        return new PlayerModifiersSyncMessage(buffer.m_130260_());
    }

    public static void handle(PlayerModifiersSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null) {
                    player.getCapability(ModCapabilities.PLAYER_TEMPERATURE).ifPresent(cap -> {
                        if (cap instanceof PlayerTempCap) {
                            PlayerTempCap playerCap = (PlayerTempCap)cap;
                            playerCap.deserializeModifiers(message.modifiers);
                        }
                    });
                }
            });
        }
        context.setPacketHandled(true);
    }
}

