/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.util.entity;

import dev.momostudios.coldsweat.api.registry.TempModifierRegistry;
import dev.momostudios.coldsweat.api.temperature.modifier.TempModifier;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class NBTHelper {
    public static Object getObjectFromTag(Tag inbt) {
        if (inbt instanceof StringTag) {
            StringTag stringnbt = (StringTag)inbt;
            return stringnbt.m_7916_();
        }
        if (inbt instanceof IntTag) {
            IntTag intnbt = (IntTag)inbt;
            return intnbt.m_7047_();
        }
        if (inbt instanceof FloatTag) {
            FloatTag floatnbt = (FloatTag)inbt;
            return Float.valueOf(floatnbt.m_7057_());
        }
        if (inbt instanceof DoubleTag) {
            DoubleTag dbnbt = (DoubleTag)inbt;
            return dbnbt.m_7061_();
        }
        if (inbt instanceof ShortTag) {
            ShortTag shortnbt = (ShortTag)inbt;
            return shortnbt.m_7053_();
        }
        if (inbt instanceof LongTag) {
            LongTag longnbt = (LongTag)inbt;
            return longnbt.m_7046_();
        }
        if (inbt instanceof IntArrayTag) {
            IntArrayTag int2nbt = (IntArrayTag)inbt;
            return int2nbt.m_128648_();
        }
        if (inbt instanceof LongArrayTag) {
            LongArrayTag long2nbt = (LongArrayTag)inbt;
            return long2nbt.m_128851_();
        }
        if (inbt instanceof ByteArrayTag) {
            ByteArrayTag byte2nbt = (ByteArrayTag)inbt;
            return byte2nbt.m_128227_();
        }
        if (inbt instanceof ByteTag) {
            return ((ByteTag)inbt).m_7063_() != 0;
        }
        throw new UnsupportedOperationException("Unsupported Tag type: " + inbt.getClass().getName());
    }

    public static Tag getTagFromObject(Object object) {
        if (object instanceof String) {
            String str = (String)object;
            return StringTag.m_129297_((String)str);
        }
        if (object instanceof Integer) {
            Integer intr = (Integer)object;
            return IntTag.m_128679_((int)intr);
        }
        if (object instanceof Float) {
            Float flt = (Float)object;
            return FloatTag.m_128566_((float)flt.floatValue());
        }
        if (object instanceof Double) {
            Double dbl = (Double)object;
            return DoubleTag.m_128500_((double)dbl);
        }
        if (object instanceof Short) {
            Short shrt = (Short)object;
            return ShortTag.m_129258_((short)shrt);
        }
        if (object instanceof Long) {
            Long lng = (Long)object;
            return LongTag.m_128882_((long)lng);
        }
        if (object instanceof int[]) {
            int[] intarr = (int[])object;
            return new IntArrayTag(intarr);
        }
        if (object instanceof long[]) {
            long[] lngarr = (long[])object;
            return new LongArrayTag(lngarr);
        }
        if (object instanceof byte[]) {
            byte[] bytearr = (byte[])object;
            return new ByteArrayTag(bytearr);
        }
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return ByteTag.m_128266_((byte)(bool != false ? (byte)1 : 0));
        }
        throw new UnsupportedOperationException("Unsupported object type: " + object.getClass().getName());
    }

    public static CompoundTag modifierToTag(TempModifier modifier) {
        CompoundTag modifierTag = new CompoundTag();
        modifierTag.m_128359_("id", modifier.getID());
        modifier.getArguments().forEach((name, value) -> modifierTag.m_128365_(name, NBTHelper.getTagFromObject(value)));
        if (modifier.getExpireTime() != -1) {
            modifierTag.m_128405_("expireTicks", modifier.getExpireTime());
        }
        if (modifier.getTickRate() > 1) {
            modifierTag.m_128405_("tickRate", modifier.getTickRate());
        }
        modifierTag.m_128405_("ticksExisted", modifier.getTicksExisted());
        return modifierTag;
    }

    public static TempModifier tagToModifier(CompoundTag modifierTag) {
        TempModifier newModifier = TempModifierRegistry.getEntryFor(modifierTag.m_128461_("id"));
        if (newModifier == null) {
            return null;
        }
        modifierTag.m_128431_().forEach(key -> {
            List<String> invalidArgs = Arrays.asList("id", "expireTicks", "tickRate", "ticksExisted");
            if (key != null && !invalidArgs.contains(modifierTag.m_128423_(key).m_7916_())) {
                newModifier.addArgument((String)key, NBTHelper.getObjectFromTag(modifierTag.m_128423_(key)));
            }
        });
        if (modifierTag.m_128441_("expireTicks")) {
            newModifier.expires(modifierTag.m_128451_("expireTicks"));
        }
        if (modifierTag.m_128441_("tickRate")) {
            newModifier.tickRate(modifierTag.m_128451_("tickRate"));
        }
        newModifier.setTicksExisted(modifierTag.m_128451_("ticksExisted"));
        return newModifier;
    }

    public static void incrementTag(Object owner, String key, int amount) {
        NBTHelper.incrementTag(owner, key, amount, tag -> true);
    }

    public static int incrementTag(Object owner, String key, int amount, Predicate<Integer> predicate) {
        CompoundTag tag;
        if (owner instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)owner;
            tag = entity.getPersistentData();
        } else if (owner instanceof ItemStack) {
            ItemStack stack = (ItemStack)owner;
            tag = stack.m_41784_();
        } else if (owner instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)owner;
            tag = blockEntity.getTileData();
        } else {
            return 0;
        }
        int value = tag.m_128451_(key);
        if (predicate.test(value)) {
            tag.m_128405_(key, value + amount);
        }
        return value + amount;
    }
}

