/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.util.world;

import dev.momostudios.coldsweat.util.math.CSMath;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;

public class SpreadPath {
    Direction direction;
    BlockPos pos;
    boolean frozen = false;
    int step = 0;

    public SpreadPath(BlockPos pos) {
        this.pos = pos;
        this.direction = Direction.UP;
    }

    public SpreadPath(BlockPos pos, Direction direction) {
        this.direction = direction;
        this.pos = pos;
    }

    public SpreadPath(int x, int y, int z, Direction direction) {
        this.direction = direction;
        this.pos = new BlockPos(x, y, z);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void freeze() {
        this.frozen = true;
    }

    public int getX() {
        return this.pos.m_123341_();
    }

    public int getY() {
        return this.pos.m_123342_();
    }

    public int getZ() {
        return this.pos.m_123343_();
    }

    public int getStep() {
        return this.step;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public SpreadPath offset(int x, int y, int z) {
        SpreadPath path = new SpreadPath(this.getX() + x, this.getY() + y, this.getZ() + z, this.direction);
        path.step = this.step + (int)CSMath.getDistance((Vec3i)this.pos, (Vec3i)path.pos);
        return path;
    }

    public SpreadPath offset(Direction dir) {
        return this.offset(dir, 1);
    }

    public SpreadPath offset(Direction dir, int steps) {
        return this.offset(dir.m_122429_() * steps, dir.m_122430_() * steps, dir.m_122431_() * steps);
    }

    public SpreadPath offset(BlockPos pos) {
        return this.offset(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public boolean withinDistance(Vec3i vector, double distance) {
        return this.distanceSq(vector.m_123341_(), vector.m_123342_(), vector.m_123343_()) < distance * distance;
    }

    public double distanceSq(double x, double y, double z) {
        double d1 = (double)this.getX() - x;
        double d2 = (double)this.getY() - y;
        double d3 = (double)this.getZ() - z;
        return d1 * d1 + d2 * d2 + d3 * d3;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpreadPath that = (SpreadPath)o;
        return this.pos.equals((Object)that.pos);
    }
}

