/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.client.animation.api;

import com.cursedcauldron.wildbackport.client.animation.api.AnimatedModel;
import com.cursedcauldron.wildbackport.client.animation.api.Animation;
import com.cursedcauldron.wildbackport.client.animation.api.Keyframe;
import com.cursedcauldron.wildbackport.client.animation.api.Transformation;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AnimationHelper {
    public static void animate(AnimatedModel<?> model, Animation animation, long runningTime, float speed, Vector3f cache) {
        float runningSeconds = AnimationHelper.getRunningSeconds(animation, runningTime);
        for (Map.Entry<String, List<Transformation>> animations : animation.boneAnimations().entrySet()) {
            Optional<ModelPart> modelPart = model.getChild(animations.getKey());
            List<Transformation> transformations = animations.getValue();
            modelPart.ifPresent(part -> transformations.forEach(transformation -> {
                Keyframe[] keyframes = transformation.keyframes();
                int start = Math.max(0, Mth.m_14049_((int)0, (int)keyframes.length, i -> runningSeconds <= keyframes[i].timestamp()) - 1);
                int end = Math.min(keyframes.length - 1, start + 1);
                Keyframe frameStart = keyframes[start];
                Keyframe frameEnd = keyframes[end];
                float current = runningSeconds - frameStart.timestamp();
                float delta = Mth.m_14036_((float)(current / (frameEnd.timestamp() - frameStart.timestamp())), (float)0.0f, (float)1.0f);
                frameEnd.interpolation().apply(cache, delta, keyframes, start, end, speed);
                transformation.target().apply((ModelPart)part, cache);
            }));
        }
    }

    private static float getRunningSeconds(Animation animation, long runningTime) {
        float time = (float)runningTime / 1000.0f;
        return animation.looping() ? time % animation.lengthInSeconds() : time;
    }

    public static Vector3f translate(float x, float y, float z) {
        return new Vector3f(x, -y, z);
    }

    public static Vector3f rotation(float x, float y, float z) {
        return new Vector3f(x * ((float)Math.PI / 180), y * ((float)Math.PI / 180), z * ((float)Math.PI / 180));
    }

    public static Vector3f scale(double x, double y, double z) {
        return new Vector3f((float)(x - 1.0), (float)(y - 1.0), (float)(z - 1.0));
    }
}

