/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.client.render;

import com.cursedcauldron.wildbackport.client.render.model.ChestBoatModel;
import com.cursedcauldron.wildbackport.common.entities.MangroveBoat;
import com.cursedcauldron.wildbackport.common.entities.access.api.BoatTypes;
import com.google.common.collect.ImmutableMap;
import com.ibm.icu.impl.Pair;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;

public class ChestBoatRenderer
extends EntityRenderer<MangroveBoat> {
    private final Map<Boat.Type, Pair<ResourceLocation, ChestBoatModel>> boatResources;

    public ChestBoatRenderer(EntityRendererProvider.Context context, boolean chest) {
        super(context);
        this.f_114477_ = 0.8f;
        this.boatResources = (Map)Stream.of(Boat.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)ChestBoatRenderer.getTexture(type, chest), (Object)((Object)this.createModel(context, (Boat.Type)type, chest)))));
    }

    private ChestBoatModel createModel(EntityRendererProvider.Context context, Boat.Type type, boolean chest) {
        ModelLayerLocation layer = chest ? ChestBoatModel.createChestBoat(type) : ModelLayers.m_171289_((Boat.Type)type);
        return new ChestBoatModel(context.m_174023_(layer), chest);
    }

    private static ResourceLocation getTexture(Boat.Type type, boolean chested) {
        if (chested) {
            return new ResourceLocation("wildbackport", "textures/entity/chest_boat/" + type.m_38429_() + ".png");
        }
        return new ResourceLocation(type == BoatTypes.MANGROVE.get() ? "wildbackport" : "minecraft", "textures/entity/boat/" + type.m_38429_() + ".png");
    }

    public void render(MangroveBoat boat, float yaw, float angle, PoseStack stack, MultiBufferSource buffer, int light) {
        float bubbleTilt;
        stack.m_85836_();
        stack.m_85837_(0.0, 0.375, 0.0);
        stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - yaw));
        float hurtTilt = (float)boat.m_38385_() - angle;
        float damageTilt = boat.m_38384_() - angle;
        if (damageTilt < 0.0f) {
            damageTilt = 0.0f;
        }
        if (hurtTilt > 0.0f) {
            stack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)hurtTilt) * hurtTilt * damageTilt / 10.0f * (float)boat.m_38386_()));
        }
        if (!Mth.m_14033_((float)(bubbleTilt = boat.m_38352_(angle)), (float)0.0f)) {
            stack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), boat.m_38352_(angle), true));
        }
        Pair<ResourceLocation, ChestBoatModel> resource = this.boatResources.get(boat.m_38387_());
        ResourceLocation location = (ResourceLocation)resource.first;
        ChestBoatModel model = (ChestBoatModel)((Object)resource.second);
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        stack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        model.setupAnim(boat, angle, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer render = buffer.m_6299_(model.m_103119_(location));
        model.m_7695_(stack, render, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boat.m_5842_()) {
            VertexConsumer waterRender = buffer.m_6299_(RenderType.m_110478_());
            model.waterPatch().m_104301_(stack, waterRender, light, OverlayTexture.f_118083_);
        }
        stack.m_85849_();
        super.m_7392_((Entity)boat, yaw, angle, stack, buffer, light);
    }

    public ResourceLocation getTextureLocation(MangroveBoat boat) {
        return (ResourceLocation)this.boatResources.get((Object)boat.m_38387_()).first;
    }
}

