/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.client.render.model;

import com.cursedcauldron.wildbackport.client.animation.WardenAnimations;
import com.cursedcauldron.wildbackport.client.animation.api.Animated;
import com.cursedcauldron.wildbackport.client.animation.api.AnimatedModel;
import com.cursedcauldron.wildbackport.common.entities.Warden;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;

public class WardenModel<T extends Warden>
extends AnimatedModel<T> {
    private final ModelPart root;
    protected final ModelPart bone;
    protected final ModelPart body;
    protected final ModelPart head;
    protected final ModelPart rightTendril;
    protected final ModelPart leftTendril;
    protected final ModelPart leftLeg;
    protected final ModelPart leftArm;
    protected final ModelPart leftRibcage;
    protected final ModelPart rightArm;
    protected final ModelPart rightLeg;
    protected final ModelPart rightRibcage;
    private final List<ModelPart> tendrils;
    private final List<ModelPart> justBody;
    private final List<ModelPart> headAndLimbs;
    private final List<ModelPart> bodyHeadAndLimbs;

    public WardenModel(ModelPart root) {
        super(RenderType::m_110458_);
        this.root = root;
        this.bone = root.m_171324_("bone");
        this.body = this.bone.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.rightLeg = this.bone.m_171324_("right_leg");
        this.leftLeg = this.bone.m_171324_("left_leg");
        this.rightArm = this.body.m_171324_("right_arm");
        this.leftArm = this.body.m_171324_("left_arm");
        this.rightTendril = this.head.m_171324_("right_tendril");
        this.leftTendril = this.head.m_171324_("left_tendril");
        this.rightRibcage = this.body.m_171324_("right_ribcage");
        this.leftRibcage = this.body.m_171324_("left_ribcage");
        this.tendrils = ImmutableList.of((Object)this.leftTendril, (Object)this.rightTendril);
        this.justBody = ImmutableList.of((Object)this.body);
        this.headAndLimbs = ImmutableList.of((Object)this.head, (Object)this.leftArm, (Object)this.rightArm, (Object)this.leftLeg, (Object)this.rightLeg);
        this.bodyHeadAndLimbs = ImmutableList.of((Object)this.body, (Object)this.head, (Object)this.leftArm, (Object)this.rightArm, (Object)this.leftLeg, (Object)this.rightLeg);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition bone = root.m_171599_("bone", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = bone.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-9.0f, -13.0f, -4.0f, 18.0f, 21.0f, 11.0f), PartPose.m_171419_((float)0.0f, (float)-21.0f, (float)0.0f));
        body.m_171599_("right_ribcage", CubeListBuilder.m_171558_().m_171514_(90, 11).m_171481_(-2.0f, -11.0f, -0.1f, 9.0f, 21.0f, 0.0f), PartPose.m_171419_((float)-7.0f, (float)-2.0f, (float)-4.0f));
        body.m_171599_("left_ribcage", CubeListBuilder.m_171558_().m_171514_(90, 11).m_171480_().m_171481_(-7.0f, -11.0f, -0.1f, 9.0f, 21.0f, 0.0f).m_171555_(false), PartPose.m_171419_((float)7.0f, (float)-2.0f, (float)-4.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(-8.0f, -16.0f, -5.0f, 16.0f, 16.0f, 10.0f), PartPose.m_171419_((float)0.0f, (float)-13.0f, (float)0.0f));
        head.m_171599_("right_tendril", CubeListBuilder.m_171558_().m_171514_(52, 32).m_171481_(-16.0f, -13.0f, 0.0f, 16.0f, 16.0f, 0.0f), PartPose.m_171419_((float)-8.0f, (float)-12.0f, (float)0.0f));
        head.m_171599_("left_tendril", CubeListBuilder.m_171558_().m_171514_(58, 0).m_171481_(0.0f, -13.0f, 0.0f, 16.0f, 16.0f, 0.0f), PartPose.m_171419_((float)8.0f, (float)-12.0f, (float)0.0f));
        body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(44, 50).m_171481_(-4.0f, 0.0f, -4.0f, 8.0f, 28.0f, 8.0f), PartPose.m_171419_((float)-13.0f, (float)-13.0f, (float)1.0f));
        body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 58).m_171481_(-4.0f, 0.0f, -4.0f, 8.0f, 28.0f, 8.0f), PartPose.m_171419_((float)13.0f, (float)-13.0f, (float)1.0f));
        bone.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(76, 48).m_171481_(-3.1f, 0.0f, -3.0f, 6.0f, 13.0f, 6.0f), PartPose.m_171419_((float)-5.9f, (float)-13.0f, (float)0.0f));
        bone.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(76, 76).m_171481_(-2.9f, 0.0f, -3.0f, 6.0f, 13.0f, 6.0f), PartPose.m_171419_((float)5.9f, (float)-13.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)128);
    }

    public void setupAnim(T entity, float angle, float distance, float animationProgress, float yaw, float pitch) {
        this.root.m_171331_().forEach(Animated::resetToDefault);
        float tickDelta = animationProgress - (float)((Warden)entity).f_19797_;
        this.setHeadAngle(yaw, pitch);
        this.setLimbAngles(angle, distance);
        this.setHeadAndBodyAngles(animationProgress);
        this.setTendrilPitches(entity, animationProgress, tickDelta);
        this.animate(((Warden)entity).attackingAnimationState, WardenAnimations.ATTACKING, animationProgress);
        this.animate(((Warden)entity).sonicBoomAnimationState, WardenAnimations.SONIC_BOOM, animationProgress);
        this.animate(((Warden)entity).diggingAnimationState, WardenAnimations.DIGGING, animationProgress);
        this.animate(((Warden)entity).emergingAnimationState, WardenAnimations.EMERGING, animationProgress);
        this.animate(((Warden)entity).roaringAnimationState, WardenAnimations.ROARING, animationProgress);
        this.animate(((Warden)entity).sniffingAnimationState, WardenAnimations.SNIFFING, animationProgress);
    }

    private void setHeadAngle(float yaw, float pitch) {
        this.head.f_104203_ = pitch * ((float)Math.PI / 180);
        this.head.f_104204_ = yaw * ((float)Math.PI / 180);
    }

    private void setHeadAndBodyAngles(float animationProgress) {
        float angle = animationProgress * 0.1f;
        float cos = Mth.m_14089_((float)angle);
        float sin = Mth.m_14031_((float)angle);
        this.head.f_104205_ += 0.06f * cos;
        this.head.f_104203_ += 0.06f * sin;
        this.body.f_104205_ += 0.025f * sin;
        this.body.f_104203_ += 0.025f * cos;
    }

    private void setLimbAngles(float angle, float distance) {
        float roll = Math.min(0.5f, 3.0f * distance);
        float mod = angle * 0.8662f;
        float cos = Mth.m_14089_((float)mod);
        float sin = Mth.m_14031_((float)mod);
        float pitch = Math.min(0.35f, roll);
        this.head.f_104205_ += 0.3f * sin * roll;
        this.head.f_104203_ += 1.2f * Mth.m_14089_((float)(mod + 1.5707964f)) * pitch;
        this.body.f_104205_ = 0.1f * sin * roll;
        this.body.f_104203_ = 1.0f * cos * pitch;
        this.leftLeg.f_104203_ = 1.0f * cos * roll;
        this.rightLeg.f_104203_ = 1.0f * Mth.m_14089_((float)(mod + (float)Math.PI)) * roll;
        this.leftArm.f_104203_ = -(0.8f * cos * roll);
        this.leftArm.f_104205_ = 0.0f;
        this.rightArm.f_104203_ = -(0.8f * sin * roll);
        this.rightArm.f_104205_ = 0.0f;
        this.setArmPivots();
    }

    private void setArmPivots() {
        this.leftArm.f_104204_ = 0.0f;
        this.leftArm.f_104202_ = 1.0f;
        this.leftArm.f_104200_ = 13.0f;
        this.leftArm.f_104201_ = -13.0f;
        this.rightArm.f_104204_ = 0.0f;
        this.rightArm.f_104202_ = 1.0f;
        this.rightArm.f_104200_ = -13.0f;
        this.rightArm.f_104201_ = -13.0f;
    }

    private void setTendrilPitches(T warden, float animationProgress, float tickDelta) {
        float pitch;
        this.leftTendril.f_104203_ = pitch = ((Warden)warden).getTendrilPitch(tickDelta) * (float)(Math.cos((double)animationProgress * 2.25) * Math.PI * (double)0.1f);
        this.rightTendril.f_104203_ = -pitch;
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public List<ModelPart> getTendrils() {
        return this.tendrils;
    }

    public List<ModelPart> getBody() {
        return this.justBody;
    }

    public List<ModelPart> getHeadAndLimbs() {
        return this.headAndLimbs;
    }

    public List<ModelPart> getBodyHeadAndLimbs() {
        return this.bodyHeadAndLimbs;
    }
}

