/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.blocks;

import com.cursedcauldron.wildbackport.WildBackport;
import com.cursedcauldron.wildbackport.client.particle.SculkChargeParticleOptions;
import com.cursedcauldron.wildbackport.client.registry.WBParticleTypes;
import com.cursedcauldron.wildbackport.client.registry.WBSoundEvents;
import com.cursedcauldron.wildbackport.common.blocks.SculkSpreadable;
import com.cursedcauldron.wildbackport.common.blocks.SculkVeinBlock;
import com.cursedcauldron.wildbackport.common.tag.WBBlockTags;
import com.cursedcauldron.wildbackport.common.utils.DirectionUtils;
import com.cursedcauldron.wildbackport.common.utils.ModUtils;
import com.cursedcauldron.wildbackport.common.utils.ParticleUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SculkSpreadManager {
    final boolean isWorldGen;
    private final TagKey<Block> replaceableBlocks;
    private final int extraBlockChance;
    private final int maxDistance;
    private final int spreadChance;
    private final int decayChance;
    private List<Cursor> cursors = new ArrayList<Cursor>();

    public SculkSpreadManager(boolean isWorldGen, TagKey<Block> replaceableBlocks, int extraBlockChance, int maxDistance, int spreadChance, int decayChance) {
        this.isWorldGen = isWorldGen;
        this.replaceableBlocks = replaceableBlocks;
        this.extraBlockChance = extraBlockChance;
        this.maxDistance = maxDistance;
        this.spreadChance = spreadChance;
        this.decayChance = decayChance;
    }

    public static SculkSpreadManager create() {
        return new SculkSpreadManager(false, WBBlockTags.SCULK_REPLACEABLE, 10, 4, 10, 5);
    }

    public static SculkSpreadManager createWorldGen() {
        return new SculkSpreadManager(true, WBBlockTags.SCULK_REPLACEABLE_WORLD_GEN, 50, 1, 5, 10);
    }

    public TagKey<Block> getReplaceableBlocks() {
        return this.replaceableBlocks;
    }

    public int getExtraBlockChance() {
        return this.extraBlockChance;
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    public int getSpreadChance() {
        return this.spreadChance;
    }

    public int getDecayChance() {
        return this.decayChance;
    }

    public boolean isWorldGen() {
        return this.isWorldGen;
    }

    public void clearCursors() {
        this.cursors.clear();
    }

    public void readTag(CompoundTag tag) {
        if (tag.m_128425_("cursors", 9)) {
            this.cursors.clear();
            List cursors = Cursor.CODEC.listOf().parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128437_("cursors", 10))).resultOrPartial(arg_0 -> ((Logger)WildBackport.LOGGER).error(arg_0)).orElseGet(ArrayList::new);
            int size = Math.min(cursors.size(), 32);
            for (int i = 0; i < size; ++i) {
                this.addCursor((Cursor)cursors.get(i));
            }
        }
    }

    public void writeTag(CompoundTag tag) {
        Cursor.CODEC.listOf().encodeStart((DynamicOps)NbtOps.f_128958_, this.cursors).resultOrPartial(arg_0 -> ((Logger)WildBackport.LOGGER).error(arg_0)).ifPresent(value -> tag.m_128365_("cursors", value));
    }

    public void spread(BlockPos pos, int charge) {
        while (charge > 0) {
            int spread = Math.min(charge, 1000);
            this.addCursor(new Cursor(pos, spread));
            charge -= spread;
        }
    }

    private void addCursor(Cursor cursor) {
        if (this.cursors.size() < 32) {
            this.cursors.add(cursor);
        }
    }

    public void tick(LevelAccessor level, BlockPos pos, Random random, boolean shouldConvert) {
        Level side;
        Level instance;
        Level level2 = instance = level instanceof Level ? (side = (Level)level) : null;
        if (!this.cursors.isEmpty()) {
            BlockPos position;
            ArrayList<Cursor> cursors = new ArrayList<Cursor>();
            HashMap<BlockPos, Cursor> cursorPositions = new HashMap<BlockPos, Cursor>();
            Object2IntOpenHashMap positions = new Object2IntOpenHashMap();
            for (Cursor cursor : this.cursors) {
                cursor.spread(level, pos, random, this, shouldConvert);
                if (cursor.charge <= 0) {
                    SculkSpreadManager.applySculkCharge(instance, cursor.getPos(), 0);
                    continue;
                }
                position = cursor.getPos();
                positions.computeInt((Object)position, (blockPos, charge) -> (charge == null ? 0 : charge) + cursor.charge);
                Cursor target = (Cursor)cursorPositions.get(position);
                if (target == null) {
                    cursorPositions.put(position, cursor);
                    cursors.add(cursor);
                    continue;
                }
                if (!this.isWorldGen() && cursor.charge + target.charge <= 1000) {
                    target.merge(cursor);
                    continue;
                }
                cursors.add(cursor);
                if (cursor.charge >= target.charge) continue;
                cursorPositions.put(position, cursor);
            }
            for (Object2IntMap.Entry entry : positions.object2IntEntrySet()) {
                Set<Direction> directions;
                position = (BlockPos)entry.getKey();
                int exp = entry.getIntValue();
                Cursor cursor = (Cursor)cursorPositions.get(position);
                Set<Direction> set = directions = cursor == null ? null : cursor.getFacings();
                if (exp <= 0 || directions == null) continue;
                int charge2 = (int)(Math.log1p(exp) / (double)2.3f) + 1;
                int data = (charge2 << 6) + SculkVeinBlock.directionsToFlag(directions);
                SculkSpreadManager.applySculkCharge(instance, cursor.getPos(), data);
            }
            this.cursors = cursors;
        }
    }

    public static void applySculkCharge(Level level, BlockPos pos, int data) {
        ServerLevel side;
        ClientLevel side2;
        if (level == null) {
            return;
        }
        Random random = level.m_5822_();
        ClientLevel client = level.m_5776_() && level instanceof ClientLevel ? (side2 = (ClientLevel)level) : null;
        ServerLevel server = level instanceof ServerLevel ? (side = (ServerLevel)level) : null;
        int charge = data >> 6;
        if (charge > 0) {
            if (random.nextFloat() < (float)charge * 0.2f) {
                float volume = 0.15f + 0.05f * (float)charge * (float)charge * random.nextFloat();
                float pitch = 0.4f * (float)charge - 0.2f * random.nextFloat();
                if (client != null) {
                    client.m_104677_(pos, WBSoundEvents.BLOCK_SCULK_CHARGE, SoundSource.BLOCKS, volume, pitch, false);
                }
            }
            byte facings = (byte)(data & 0x3F);
            UniformInt spread = UniformInt.m_146622_((int)0, (int)charge);
            Supplier<Vec3> velocities = () -> new Vec3(Mth.m_14064_((Random)random, (double)-0.005, (double)0.005), Mth.m_14064_((Random)random, (double)-0.005, (double)0.005), Mth.m_14064_((Random)random, (double)-0.005, (double)0.005));
            if (facings == 0) {
                for (Direction direction : Direction.values()) {
                    float roll = direction == Direction.DOWN ? (float)Math.PI : 0.0f;
                    double offset = direction == Direction.UP || direction == Direction.DOWN ? 0.32 : 0.57;
                    ParticleUtils.spawnParticles(level, pos, new SculkChargeParticleOptions(roll), (IntProvider)spread, direction, velocities, offset);
                }
            } else {
                for (Direction direction : DirectionUtils.unpack((byte)data)) {
                    float roll = direction == Direction.UP ? (float)Math.PI : 0.0f;
                    ParticleUtils.spawnParticles(level, pos, new SculkChargeParticleOptions(roll), (IntProvider)spread, direction, velocities, 0.35);
                }
            }
        } else {
            boolean fullBlock;
            if (client != null) {
                client.m_104677_(pos, WBSoundEvents.BLOCK_SCULK_CHARGE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            int tries = (fullBlock = level.m_8055_(pos).m_60838_((BlockGetter)level, pos)) ? 40 : 20;
            float spread = fullBlock ? 0.45f : 0.25f;
            for (int i = 0; i < tries; ++i) {
                float x = 2.0f * random.nextFloat() - 1.0f;
                float y = 2.0f * random.nextFloat() - 1.0f;
                float z = 2.0f * random.nextFloat() - 1.0f;
                if (server == null) continue;
                server.m_8767_((ParticleOptions)WBParticleTypes.SCULK_CHARGE_POP.get(), (double)pos.m_123341_() + 0.5 + (double)(x * spread), (double)pos.m_123342_() + 0.5 + (double)(y * spread), (double)pos.m_123343_() + 0.5 + (double)(z * spread), 1, (double)(x * 0.07f), (double)(y * 0.07f), (double)(z * 0.07f), 0.0);
            }
        }
    }

    public static class Cursor {
        private static final ObjectArrayList<Vec3i> OFFSETS = (ObjectArrayList)Util.m_137469_((Object)new ObjectArrayList(18), positions -> BlockPos.m_121990_((BlockPos)new BlockPos(-1, -1, -1), (BlockPos)new BlockPos(1, 1, 1)).filter(pos -> (pos.m_123341_() == 0 || pos.m_123342_() == 0 || pos.m_123343_() == 0) && pos != BlockPos.f_121853_).map(BlockPos::m_7949_).forEach(arg_0 -> ((ObjectArrayList)positions).add(arg_0)));
        private BlockPos pos;
        private int charge;
        private int updateDelay;
        private int decayDelay;
        @Nullable
        private Set<Direction> facings;
        private static final Codec<Set<Direction>> DIRECTION_SET = Direction.f_175356_.listOf().xmap(directions -> Sets.newEnumSet((Iterable)directions, Direction.class), Lists::newArrayList);
        public static final Codec<Cursor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.fieldOf("pos").forGetter(Cursor::getPos), (App)Codec.intRange((int)0, (int)1000).fieldOf("charge").orElse((Object)0).forGetter(Cursor::getCharge), (App)Codec.intRange((int)0, (int)1).fieldOf("decay_delay").orElse((Object)1).forGetter(Cursor::getDecayDelay), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("update_delay").orElse((Object)0).forGetter(cursor -> cursor.updateDelay), (App)DIRECTION_SET.optionalFieldOf("facings").forGetter(cursor -> Optional.ofNullable(cursor.getFacings()))).apply((Applicative)instance, Cursor::new));

        private Cursor(BlockPos pos, int charge, int decayDelay, int updateDelay, Optional<Set<Direction>> facings) {
            this.pos = pos;
            this.charge = charge;
            this.decayDelay = decayDelay;
            this.updateDelay = updateDelay;
            this.facings = facings.orElse(null);
        }

        public Cursor(BlockPos pos, int charge) {
            this(pos, charge, 1, 0, Optional.empty());
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public int getCharge() {
            return this.charge;
        }

        public int getDecayDelay() {
            return this.decayDelay;
        }

        @Nullable
        public Set<Direction> getFacings() {
            return this.facings;
        }

        private boolean canSpread(LevelAccessor level, BlockPos pos, boolean isWorldGen) {
            if (this.charge <= 0) {
                return false;
            }
            if (isWorldGen) {
                return true;
            }
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                return server.m_183438_(ChunkPos.m_151388_((BlockPos)pos));
            }
            return false;
        }

        public void spread(LevelAccessor level, BlockPos pos, Random random, SculkSpreadManager spreadManager, boolean shouldConvert) {
            if (this.canSpread(level, pos, spreadManager.isWorldGen)) {
                if (this.updateDelay > 0) {
                    --this.updateDelay;
                } else {
                    BlockState state = level.m_8055_(this.pos);
                    SculkSpreadable spreadable = Cursor.getSpreadable(state);
                    if (shouldConvert && spreadable.spread(level, this.pos, state, this.facings, spreadManager.isWorldGen())) {
                        if (spreadable.shouldConvertToSpreadable()) {
                            state = level.m_8055_(this.pos);
                            spreadable = Cursor.getSpreadable(state);
                        }
                        level.m_5594_(null, this.pos, WBSoundEvents.BLOCK_SCULK_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    this.charge = spreadable.spread(this, level, pos, random, spreadManager, shouldConvert);
                    if (this.charge <= 0) {
                        spreadable.spreadAtSamePosition(level, state, this.pos, random);
                    } else {
                        BlockPos target = Cursor.getSpreadPos(level, this.pos, random);
                        if (target != null) {
                            spreadable.spreadAtSamePosition(level, state, this.pos, random);
                            this.pos = target.m_7949_();
                            if (spreadManager.isWorldGen() && !this.pos.m_123314_(new Vec3i(pos.m_123341_(), this.pos.m_123342_(), pos.m_123343_()), 15.0)) {
                                this.charge = 0;
                                return;
                            }
                            state = level.m_8055_(target);
                        }
                        if (state.m_60734_() instanceof SculkSpreadable) {
                            this.facings = SculkVeinBlock.collectDirections(state);
                        }
                        this.decayDelay = spreadable.getDecay(this.decayDelay);
                        this.updateDelay = spreadable.getUpdate();
                    }
                }
            }
        }

        void merge(Cursor cursor) {
            this.charge += cursor.charge;
            cursor.charge = 0;
            this.updateDelay = Math.min(this.updateDelay, cursor.updateDelay);
        }

        private static SculkSpreadable getSpreadable(BlockState state) {
            SculkSpreadable spreadable;
            Block block = state.m_60734_();
            return block instanceof SculkSpreadable ? (spreadable = (SculkSpreadable)block) : SculkSpreadable.DEFAULT;
        }

        private static List<Vec3i> shuffleOffsets(Random random) {
            return ModUtils.copyShuffled(OFFSETS, random);
        }

        @Nullable
        private static BlockPos getSpreadPos(LevelAccessor level, BlockPos pos, Random random) {
            BlockPos.MutableBlockPos target = pos.m_122032_();
            BlockPos.MutableBlockPos source = pos.m_122032_();
            for (Vec3i offset : Cursor.shuffleOffsets(random)) {
                source.m_175306_((Vec3i)pos, offset);
                BlockState state = level.m_8055_((BlockPos)source);
                if (!(state.m_60734_() instanceof SculkSpreadable) || !Cursor.canSpread(level, pos, (BlockPos)source)) continue;
                target.m_122190_((Vec3i)source);
                if (!SculkVeinBlock.veinCoversSculkReplaceable(level, state, (BlockPos)source)) continue;
                break;
            }
            return target.equals((Object)pos) ? null : target;
        }

        private static boolean canSpread(LevelAccessor level, BlockPos source, BlockPos target) {
            if (source.m_123333_((Vec3i)target) == 1) {
                return true;
            }
            BlockPos pos = target.m_141950_((Vec3i)target);
            Direction xAxis = Direction.m_122387_((Direction.Axis)Direction.Axis.X, (Direction.AxisDirection)(pos.m_123341_() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
            Direction yAxis = Direction.m_122387_((Direction.Axis)Direction.Axis.Y, (Direction.AxisDirection)(pos.m_123342_() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
            Direction zAxis = Direction.m_122387_((Direction.Axis)Direction.Axis.Z, (Direction.AxisDirection)(pos.m_123343_() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
            if (pos.m_123341_() == 0) {
                return Cursor.canSpread(level, source, yAxis) || Cursor.canSpread(level, source, zAxis);
            }
            if (pos.m_123342_() == 0) {
                return Cursor.canSpread(level, source, xAxis) || Cursor.canSpread(level, source, zAxis);
            }
            return Cursor.canSpread(level, source, xAxis) || Cursor.canSpread(level, source, yAxis);
        }

        private static boolean canSpread(LevelAccessor level, BlockPos pos, Direction direction) {
            BlockPos facing = pos.m_142300_(direction);
            return !level.m_8055_(facing).m_60783_((BlockGetter)level, facing, direction.m_122424_());
        }
    }
}

